/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.apigeneration.Method;
import com.microsoft.azure.management.appservice.AppServicePlan;
import com.microsoft.azure.management.appservice.FunctionDeploymentSlots;
import com.microsoft.azure.management.appservice.NameValuePair;
import com.microsoft.azure.management.appservice.PricingTier;
import com.microsoft.azure.management.appservice.WebAppBase;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.arm.models.GroupableResource;
import com.microsoft.azure.management.resources.fluentcore.arm.models.Resource;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.Refreshable;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import com.microsoft.azure.management.storage.SkuName;
import com.microsoft.azure.management.storage.StorageAccount;
import java.io.InputStream;
import java.util.Map;
import rx.Completable;
import rx.Observable;

@Fluent(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
@Beta
public interface FunctionApp
extends WebAppBase,
Refreshable<FunctionApp>,
Updatable<Update> {
    @Beta(value=Beta.SinceVersion.V1_3_0)
    public FunctionDeploymentSlots deploymentSlots();

    public StorageAccount storageAccount();

    @Method
    public String getMasterKey();

    @Method
    public Observable<String> getMasterKeyAsync();

    public Map<String, String> listFunctionKeys(String var1);

    public Observable<Map<String, String>> listFunctionKeysAsync(String var1);

    public NameValuePair addFunctionKey(String var1, String var2, String var3);

    public Observable<NameValuePair> addFunctionKeyAsync(String var1, String var2, String var3);

    public void removeFunctionKey(String var1, String var2);

    public Completable removeFunctionKeyAsync(String var1, String var2);

    @Method
    public void syncTriggers();

    @Method
    public Completable syncTriggersAsync();

    @Beta(value=Beta.SinceVersion.V1_6_0)
    @Method
    public InputStream streamApplicationLogs();

    @Beta(value=Beta.SinceVersion.V1_6_0)
    @Method
    public Observable<String> streamApplicationLogsAsync();

    public static interface Update
    extends WebAppBase.Update<FunctionApp>,
    UpdateStages.WithAppServicePlan,
    UpdateStages.WithRuntimeVersion,
    UpdateStages.WithStorageAccount,
    UpdateStages.WithDailyUsageQuota {
    }

    public static interface UpdateStages {

        public static interface WithDailyUsageQuota {
            public Update withDailyUsageQuota(int var1);

            public Update withoutDailyUsageQuota();
        }

        public static interface WithStorageAccount {
            public Update withNewStorageAccount(String var1, SkuName var2);

            public Update withExistingStorageAccount(StorageAccount var1);
        }

        public static interface WithRuntimeVersion {
            public Update withRuntimeVersion(String var1);

            public Update withLatestRuntimeVersion();
        }

        public static interface WithAppServicePlan {
            public Update withNewConsumptionPlan();

            public Update withNewFreeAppServicePlan();

            public Update withNewSharedAppServicePlan();

            public Update withNewAppServicePlan(PricingTier var1);

            public Update withNewAppServicePlan(Creatable<AppServicePlan> var1);

            public Update withExistingAppServicePlan(AppServicePlan var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<FunctionApp>,
        WithNewAppServicePlan,
        WithStorageAccount,
        WithRuntimeVersion,
        WithDailyUsageQuota,
        WebAppBase.DefinitionStages.WithCreate<FunctionApp> {
        }

        public static interface WithDailyUsageQuota {
            public WithCreate withDailyUsageQuota(int var1);

            public WithCreate withoutDailyUsageQuota();
        }

        public static interface WithRuntimeVersion {
            public WithCreate withRuntimeVersion(String var1);

            public WithCreate withLatestRuntimeVersion();
        }

        public static interface WithStorageAccount {
            public WithCreate withNewStorageAccount(String var1, SkuName var2);

            public WithCreate withExistingStorageAccount(StorageAccount var1);
        }

        public static interface WithNewAppServicePlan {
            public WithCreate withNewConsumptionPlan();

            public WithCreate withNewFreeAppServicePlan();

            public WithCreate withNewSharedAppServicePlan();

            public WithCreate withNewAppServicePlan(PricingTier var1);

            public WithCreate withNewAppServicePlan(Creatable<AppServicePlan> var1);
        }

        public static interface NewAppServicePlanWithGroup {
            public WithCreate withExistingResourceGroup(String var1);

            public WithCreate withExistingResourceGroup(ResourceGroup var1);

            public WithCreate withNewResourceGroup(String var1);

            public WithCreate withNewResourceGroup();

            public WithCreate withNewResourceGroup(Creatable<ResourceGroup> var1);
        }

        public static interface ExistingAppServicePlanWithGroup
        extends GroupableResource.DefinitionStages.WithGroup<WithCreate> {
        }

        public static interface Blank
        extends Resource.DefinitionWithRegion<NewAppServicePlanWithGroup> {
            public ExistingAppServicePlanWithGroup withExistingAppServicePlan(AppServicePlan var1);
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.ExistingAppServicePlanWithGroup,
    DefinitionStages.WithStorageAccount,
    DefinitionStages.WithCreate {
    }
}

