/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.cosmosdb.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.cosmosdb.implementation.CosmosDBImpl;
import com.microsoft.azure.management.cosmosdb.implementation.PageImpl;
import com.microsoft.azure.management.cosmosdb.implementation.PartitionMetricInner;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.GET;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.Path;
import retrofit2.http.Query;
import rx.Observable;
import rx.functions.Func1;

public class PartitionKeyRangeIdsInner {
    private PartitionKeyRangeIdsService service;
    private CosmosDBImpl client;

    public PartitionKeyRangeIdsInner(Retrofit retrofit, CosmosDBImpl client) {
        this.service = (PartitionKeyRangeIdsService)retrofit.create(PartitionKeyRangeIdsService.class);
        this.client = client;
    }

    public List<PartitionMetricInner> listMetrics(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String partitionKeyRangeId, String filter) {
        return (List)((ServiceResponse)this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, partitionKeyRangeId, filter).toBlocking().single()).body();
    }

    public ServiceFuture<List<PartitionMetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String partitionKeyRangeId, String filter, ServiceCallback<List<PartitionMetricInner>> serviceCallback) {
        return ServiceFuture.fromResponse(this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, partitionKeyRangeId, filter), serviceCallback);
    }

    public Observable<List<PartitionMetricInner>> listMetricsAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String partitionKeyRangeId, String filter) {
        return this.listMetricsWithServiceResponseAsync(resourceGroupName, accountName, databaseRid, collectionRid, partitionKeyRangeId, filter).map((Func1)new Func1<ServiceResponse<List<PartitionMetricInner>>, List<PartitionMetricInner>>(){

            public List<PartitionMetricInner> call(ServiceResponse<List<PartitionMetricInner>> response) {
                return (List)response.body();
            }
        });
    }

    public Observable<ServiceResponse<List<PartitionMetricInner>>> listMetricsWithServiceResponseAsync(String resourceGroupName, String accountName, String databaseRid, String collectionRid, String partitionKeyRangeId, String filter) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (databaseRid == null) {
            throw new IllegalArgumentException("Parameter databaseRid is required and cannot be null.");
        }
        if (collectionRid == null) {
            throw new IllegalArgumentException("Parameter collectionRid is required and cannot be null.");
        }
        if (partitionKeyRangeId == null) {
            throw new IllegalArgumentException("Parameter partitionKeyRangeId is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Parameter filter is required and cannot be null.");
        }
        return this.service.listMetrics(this.client.subscriptionId(), resourceGroupName, accountName, databaseRid, collectionRid, partitionKeyRangeId, this.client.apiVersion(), filter, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<List<PartitionMetricInner>>>>(){

            public Observable<ServiceResponse<List<PartitionMetricInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = PartitionKeyRangeIdsInner.this.listMetricsDelegate((Response<ResponseBody>)response);
                    ServiceResponse clientResponse = new ServiceResponse(((PageImpl)result.body()).items(), result.response());
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<PartitionMetricInner>> listMetricsDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<PartitionMetricInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface PartitionKeyRangeIdsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.cosmosdb.PartitionKeyRangeIds listMetrics"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DocumentDB/databaseAccounts/{accountName}/databases/{databaseRid}/collections/{collectionRid}/partitionKeyRangeId/{partitionKeyRangeId}/metrics")
        public Observable<Response<ResponseBody>> listMetrics(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Path(value="accountName") String var3, @Path(value="databaseRid") String var4, @Path(value="collectionRid") String var5, @Path(value="partitionKeyRangeId") String var6, @Query(value="api-version") String var7, @Query(value="$filter") String var8, @Header(value="accept-language") String var9, @Header(value="User-Agent") String var10);
    }
}

