/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.eventhub.EventHub;
import com.microsoft.azure.management.eventhub.EventHubAuthorizationRule;
import com.microsoft.azure.management.eventhub.KeyType;
import com.microsoft.azure.management.eventhub.implementation.AccessKeysInner;
import com.microsoft.azure.management.eventhub.implementation.Ancestors;
import com.microsoft.azure.management.eventhub.implementation.AuthorizationRuleBaseImpl;
import com.microsoft.azure.management.eventhub.implementation.AuthorizationRuleInner;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManager;
import com.microsoft.azure.management.eventhub.implementation.RegenerateAccessKeyParametersInner;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.Objects;
import rx.Observable;

@LangDefinition
class EventHubAuthorizationRuleImpl
extends AuthorizationRuleBaseImpl<EventHubAuthorizationRule, EventHubAuthorizationRuleImpl>
implements EventHubAuthorizationRule,
EventHubAuthorizationRule.Definition,
EventHubAuthorizationRule.Update {
    private Ancestors.TwoAncestor ancestor;

    EventHubAuthorizationRuleImpl(String name, AuthorizationRuleInner inner, EventHubManager manager) {
        super(name, inner, manager);
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.TwoAncestor(inner.id());
    }

    EventHubAuthorizationRuleImpl(String name, EventHubManager manager) {
        super(name, new AuthorizationRuleInner(), manager);
    }

    @Override
    public String namespaceResourceGroupName() {
        return this.ancestor().resourceGroupName();
    }

    @Override
    public String namespaceName() {
        return this.ancestor().ancestor2Name();
    }

    @Override
    public String eventHubName() {
        return this.ancestor().ancestor1Name();
    }

    @Override
    public EventHubAuthorizationRuleImpl withExistingEventHubId(String eventHubResourceId) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.TwoAncestor(this.selfId(eventHubResourceId));
        return this;
    }

    @Override
    public EventHubAuthorizationRuleImpl withExistingEventHub(String resourceGroupName, String namespaceName, String eventHubName) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.TwoAncestor(resourceGroupName, eventHubName, namespaceName);
        return this;
    }

    @Override
    public EventHubAuthorizationRuleImpl withExistingEventHub(EventHub eventHub) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.TwoAncestor(this.selfId(eventHub.id()));
        return this;
    }

    @Override
    protected Observable<AuthorizationRuleInner> getInnerAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager.inner())).eventHubs().getAuthorizationRuleAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor2Name(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    public Observable<EventHubAuthorizationRule> createResourceAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager.inner())).eventHubs().createOrUpdateAuthorizationRuleAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor2Name(), this.ancestor().ancestor1Name(), this.name(), ((AuthorizationRuleInner)this.inner()).rights()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    @Override
    protected Observable<AccessKeysInner> getKeysInnerAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager.inner())).eventHubs().listKeysAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor2Name(), this.ancestor().ancestor1Name(), this.name());
    }

    @Override
    protected Observable<AccessKeysInner> regenerateKeysInnerAsync(KeyType keyType) {
        RegenerateAccessKeyParametersInner regenKeyInner = new RegenerateAccessKeyParametersInner().withKeyType(keyType);
        return ((EventHubManagementClientImpl)((Object)this.manager.inner())).eventHubs().regenerateKeysAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor2Name(), this.ancestor().ancestor1Name(), this.name(), regenKeyInner);
    }

    private Ancestors.TwoAncestor ancestor() {
        Objects.requireNonNull(this.ancestor);
        return this.ancestor;
    }

    private String selfId(String parentId) {
        return String.format("%s/authorizationRules/%s", parentId, this.name());
    }
}

