/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.eventhub.implementation;

import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.eventhub.EventHub;
import com.microsoft.azure.management.eventhub.EventHubConsumerGroup;
import com.microsoft.azure.management.eventhub.implementation.Ancestors;
import com.microsoft.azure.management.eventhub.implementation.ConsumerGroupInner;
import com.microsoft.azure.management.eventhub.implementation.EventHubManagementClientImpl;
import com.microsoft.azure.management.eventhub.implementation.EventHubManager;
import com.microsoft.azure.management.eventhub.implementation.NestedResourceImpl;
import com.microsoft.azure.management.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.Objects;
import org.joda.time.DateTime;
import rx.Observable;

@LangDefinition
class EventHubConsumerGroupImpl
extends NestedResourceImpl<EventHubConsumerGroup, ConsumerGroupInner, EventHubConsumerGroupImpl>
implements EventHubConsumerGroup,
EventHubConsumerGroup.Definition,
EventHubConsumerGroup.Update {
    private Ancestors.TwoAncestor ancestor;

    EventHubConsumerGroupImpl(String name, ConsumerGroupInner inner, EventHubManager manager) {
        super(name, inner, manager);
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.TwoAncestor(inner.id());
    }

    EventHubConsumerGroupImpl(String name, EventHubManager manager) {
        super(name, new ConsumerGroupInner(), manager);
    }

    @Override
    public String namespaceResourceGroupName() {
        return this.ancestor().resourceGroupName();
    }

    @Override
    public String namespaceName() {
        return this.ancestor().ancestor2Name();
    }

    @Override
    public String eventHubName() {
        return this.ancestor().ancestor1Name();
    }

    @Override
    public DateTime createdAt() {
        return ((ConsumerGroupInner)this.inner()).createdAt();
    }

    @Override
    public DateTime updatedAt() {
        return ((ConsumerGroupInner)this.inner()).updatedAt();
    }

    @Override
    public String userMetadata() {
        return ((ConsumerGroupInner)this.inner()).userMetadata();
    }

    @Override
    public EventHubConsumerGroupImpl withExistingEventHub(EventHub eventHub) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.TwoAncestor(this.selfId(eventHub.id()));
        return this;
    }

    @Override
    public EventHubConsumerGroupImpl withExistingEventHubId(String eventHubId) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.TwoAncestor(this.selfId(eventHubId));
        return this;
    }

    @Override
    public EventHubConsumerGroupImpl withExistingEventHub(String resourceGroupName, String namespaceName, String eventHubName) {
        Ancestors ancestors = new Ancestors();
        ancestors.getClass();
        this.ancestor = ancestors.new Ancestors.TwoAncestor(resourceGroupName, eventHubName, namespaceName);
        return this;
    }

    @Override
    public EventHubConsumerGroupImpl withUserMetadata(String metadata) {
        ((ConsumerGroupInner)this.inner()).withUserMetadata(metadata);
        return this;
    }

    public Observable<EventHubConsumerGroup> createResourceAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager.inner())).consumerGroups().createOrUpdateAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor2Name(), this.ancestor().ancestor1Name(), this.name(), ((ConsumerGroupInner)this.inner()).userMetadata()).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Observable<ConsumerGroupInner> getInnerAsync() {
        return ((EventHubManagementClientImpl)((Object)this.manager.inner())).consumerGroups().getAsync(this.ancestor().resourceGroupName(), this.ancestor().ancestor2Name(), this.ancestor().ancestor1Name(), this.name());
    }

    private Ancestors.TwoAncestor ancestor() {
        Objects.requireNonNull(this.ancestor);
        return this.ancestor;
    }

    private String selfId(String parentId) {
        return String.format("%s/consumerGroups/%s", parentId, this.name());
    }
}

