/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac;

import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryApplication;
import com.microsoft.azure.management.graphrbac.ActiveDirectoryObject;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.CertificateCredential;
import com.microsoft.azure.management.graphrbac.PasswordCredential;
import com.microsoft.azure.management.graphrbac.RoleAssignment;
import com.microsoft.azure.management.graphrbac.implementation.ServicePrincipalInner;
import com.microsoft.azure.management.resources.ResourceGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Appliable;
import com.microsoft.azure.management.resources.fluentcore.model.Creatable;
import com.microsoft.azure.management.resources.fluentcore.model.HasInner;
import com.microsoft.azure.management.resources.fluentcore.model.Updatable;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Fluent(ContainerName="/Microsoft.Azure.Management.Graph.RBAC.Fluent")
@Beta
public interface ServicePrincipal
extends ActiveDirectoryObject,
HasInner<ServicePrincipalInner>,
Updatable<Update> {
    public String applicationId();

    public List<String> servicePrincipalNames();

    @Beta(value=Beta.SinceVersion.V1_1_0)
    public Map<String, PasswordCredential> passwordCredentials();

    @Beta(value=Beta.SinceVersion.V1_1_0)
    public Map<String, CertificateCredential> certificateCredentials();

    @Beta(value=Beta.SinceVersion.V1_2_0)
    public Set<RoleAssignment> roleAssignments();

    public static interface Update
    extends Appliable<ServicePrincipal>,
    UpdateStages.WithCredential,
    UpdateStages.WithRoleAssignment {
    }

    public static interface UpdateStages {

        public static interface WithRoleAssignment {
            @Beta(value=Beta.SinceVersion.V1_2_0)
            public Update withNewRole(BuiltInRole var1, String var2);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public Update withNewRoleInSubscription(BuiltInRole var1, String var2);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public Update withNewRoleInResourceGroup(BuiltInRole var1, ResourceGroup var2);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public Update withoutRole(RoleAssignment var1);
        }

        public static interface WithCredential {
            @Beta(value=Beta.SinceVersion.V1_2_0)
            public CertificateCredential.UpdateDefinitionStages.Blank<Update> defineCertificateCredential(String var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public PasswordCredential.UpdateDefinitionStages.Blank<Update> definePasswordCredential(String var1);

            @Beta(value=Beta.SinceVersion.V1_2_0)
            public Update withoutCredential(String var1);
        }
    }

    public static interface DefinitionStages {

        public static interface WithCreate
        extends Creatable<ServicePrincipal>,
        WithCredential,
        WithRoleAssignment {
        }

        public static interface WithRoleAssignment {
            @Beta(value=Beta.SinceVersion.V1_1_0)
            public WithCreate withNewRole(BuiltInRole var1, String var2);

            @Beta(value=Beta.SinceVersion.V1_1_0)
            public WithCreate withNewRoleInSubscription(BuiltInRole var1, String var2);

            @Beta(value=Beta.SinceVersion.V1_1_0)
            public WithCreate withNewRoleInResourceGroup(BuiltInRole var1, ResourceGroup var2);
        }

        public static interface WithCredential {
            @Beta(value=Beta.SinceVersion.V1_1_0)
            public CertificateCredential.DefinitionStages.Blank<WithCreate> defineCertificateCredential(String var1);

            @Beta(value=Beta.SinceVersion.V1_1_0)
            public PasswordCredential.DefinitionStages.Blank<WithCreate> definePasswordCredential(String var1);
        }

        public static interface WithApplication {
            @Beta(value=Beta.SinceVersion.V1_1_0)
            public WithCreate withExistingApplication(String var1);

            @Beta(value=Beta.SinceVersion.V1_1_0)
            public WithCreate withExistingApplication(ActiveDirectoryApplication var1);

            @Beta(value=Beta.SinceVersion.V1_1_0)
            public WithCreate withNewApplication(Creatable<ActiveDirectoryApplication> var1);

            @Beta(value=Beta.SinceVersion.V1_1_0)
            public WithCreate withNewApplication(String var1);
        }

        public static interface Blank
        extends WithApplication {
        }
    }

    public static interface Definition
    extends DefinitionStages.Blank,
    DefinitionStages.WithCreate {
    }
}

