/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.graphrbac.implementation;

import com.microsoft.azure.CloudException;
import com.microsoft.azure.management.apigeneration.Beta;
import com.microsoft.azure.management.apigeneration.LangDefinition;
import com.microsoft.azure.management.graphrbac.BuiltInRole;
import com.microsoft.azure.management.graphrbac.RoleAssignment;
import com.microsoft.azure.management.graphrbac.RoleDefinition;
import com.microsoft.azure.management.graphrbac.implementation.GraphRbacManager;
import com.microsoft.azure.management.resources.fluentcore.arm.ResourceId;
import com.microsoft.azure.management.resources.fluentcore.dag.FunctionalTaskItem;
import com.microsoft.azure.management.resources.fluentcore.dag.TaskGroup;
import com.microsoft.azure.management.resources.fluentcore.model.Indexable;
import com.microsoft.azure.management.resources.fluentcore.utils.SdkContext;
import java.util.Objects;
import rx.Observable;
import rx.functions.Func1;

@LangDefinition
@Beta
public class RoleAssignmentHelper {
    private static final String CURRENT_RESOURCE_GROUP_SCOPE = "CURRENT_RESOURCE_GROUP";
    private final GraphRbacManager rbacManager;
    private final IdProvider idProvider;
    private final TaskGroup preRunTaskGroup;

    public RoleAssignmentHelper(GraphRbacManager rbacManager, TaskGroup taskGroup, IdProvider idProvider) {
        this.rbacManager = Objects.requireNonNull(rbacManager);
        this.idProvider = Objects.requireNonNull(idProvider);
        this.preRunTaskGroup = Objects.requireNonNull(taskGroup);
    }

    public RoleAssignmentHelper withAccessToCurrentResourceGroup(BuiltInRole asRole) {
        return this.withAccessTo(CURRENT_RESOURCE_GROUP_SCOPE, asRole);
    }

    public RoleAssignmentHelper withAccessTo(final String scope, final BuiltInRole asRole) {
        FunctionalTaskItem creator = new FunctionalTaskItem(){

            public Observable<Indexable> call(final FunctionalTaskItem.Context cxt) {
                String principalId = RoleAssignmentHelper.this.idProvider.principalId();
                if (principalId == null) {
                    return cxt.voidObservable();
                }
                String roleAssignmentName = SdkContext.randomUuid();
                String resourceScope = scope == RoleAssignmentHelper.CURRENT_RESOURCE_GROUP_SCOPE ? RoleAssignmentHelper.resourceGroupId(RoleAssignmentHelper.this.idProvider.resourceId()) : scope;
                return ((RoleAssignment.DefinitionStages.Blank)RoleAssignmentHelper.this.rbacManager.roleAssignments().define(roleAssignmentName)).forObjectId(principalId).withBuiltInRole(asRole).withScope(resourceScope).createAsync().last().onErrorResumeNext((Func1)new Func1<Throwable, Observable<Indexable>>(){

                    public Observable<Indexable> call(Throwable throwable) {
                        if (RoleAssignmentHelper.isRoleAssignmentExists(throwable)) {
                            return cxt.voidObservable();
                        }
                        return Observable.error((Throwable)throwable);
                    }
                });
            }
        };
        this.preRunTaskGroup.addPostRunDependent(creator);
        return this;
    }

    public RoleAssignmentHelper withAccessToCurrentResourceGroup(String roleDefinitionId) {
        return this.withAccessTo(CURRENT_RESOURCE_GROUP_SCOPE, roleDefinitionId);
    }

    public RoleAssignmentHelper withAccessTo(final String scope, final String roleDefinitionId) {
        FunctionalTaskItem creator = new FunctionalTaskItem(){

            public Observable<Indexable> call(final FunctionalTaskItem.Context cxt) {
                String principalId = RoleAssignmentHelper.this.idProvider.principalId();
                if (principalId == null) {
                    return cxt.voidObservable();
                }
                String roleAssignmentName = SdkContext.randomUuid();
                String resourceScope = scope == RoleAssignmentHelper.CURRENT_RESOURCE_GROUP_SCOPE ? RoleAssignmentHelper.resourceGroupId(RoleAssignmentHelper.this.idProvider.resourceId()) : scope;
                return ((RoleAssignment.DefinitionStages.Blank)RoleAssignmentHelper.this.rbacManager.roleAssignments().define(roleAssignmentName)).forObjectId(principalId).withRoleDefinition(roleDefinitionId).withScope(resourceScope).createAsync().last().onErrorResumeNext((Func1)new Func1<Throwable, Observable<Indexable>>(){

                    public Observable<Indexable> call(Throwable throwable) {
                        if (RoleAssignmentHelper.isRoleAssignmentExists(throwable)) {
                            return cxt.voidObservable();
                        }
                        return Observable.error((Throwable)throwable);
                    }
                });
            }
        };
        this.preRunTaskGroup.addPostRunDependent(creator);
        return this;
    }

    public RoleAssignmentHelper withoutAccessTo(final RoleAssignment roleAssignment) {
        String principalId = roleAssignment.principalId();
        if (principalId == null || !principalId.equalsIgnoreCase(this.idProvider.principalId())) {
            return this;
        }
        FunctionalTaskItem remover = new FunctionalTaskItem(){

            public Observable<Indexable> call(FunctionalTaskItem.Context cxt) {
                return RoleAssignmentHelper.this.rbacManager.roleAssignments().deleteByIdAsync(roleAssignment.id()).toObservable().switchIfEmpty(cxt.voidObservable());
            }
        };
        this.preRunTaskGroup.addPostRunDependent(remover);
        return this;
    }

    public RoleAssignmentHelper withoutAccessTo(final String scope, final BuiltInRole asRole) {
        FunctionalTaskItem remover = new FunctionalTaskItem(){

            public Observable<Indexable> call(final FunctionalTaskItem.Context cxt) {
                return RoleAssignmentHelper.this.rbacManager.roleDefinitions().getByScopeAndRoleNameAsync(scope, asRole.toString()).flatMap((Func1)new Func1<RoleDefinition, Observable<RoleAssignment>>(){

                    public Observable<RoleAssignment> call(final RoleDefinition roleDefinition) {
                        return RoleAssignmentHelper.this.rbacManager.roleAssignments().listByScopeAsync(scope).filter((Func1)new Func1<RoleAssignment, Boolean>(){

                            public Boolean call(RoleAssignment roleAssignment) {
                                if (roleDefinition != null && roleAssignment != null) {
                                    return roleAssignment.roleDefinitionId().equalsIgnoreCase(roleDefinition.id()) && roleAssignment.principalId().equalsIgnoreCase(RoleAssignmentHelper.this.idProvider.principalId());
                                }
                                return false;
                            }
                        }).first();
                    }
                }).flatMap((Func1)new Func1<RoleAssignment, Observable<Indexable>>(){

                    public Observable<Indexable> call(RoleAssignment roleAssignment) {
                        return RoleAssignmentHelper.this.rbacManager.roleAssignments().deleteByIdAsync(roleAssignment.id()).toObservable().switchIfEmpty(cxt.voidObservable());
                    }
                });
            }
        };
        this.preRunTaskGroup.addPostRunDependent(remover);
        return this;
    }

    private static String resourceGroupId(String id) {
        ResourceId resourceId = ResourceId.fromString((String)id);
        StringBuilder builder = new StringBuilder();
        builder.append("/subscriptions/").append(resourceId.subscriptionId()).append("/resourceGroups/").append(resourceId.resourceGroupName());
        return builder.toString();
    }

    private static boolean isRoleAssignmentExists(Throwable throwable) {
        CloudException exception;
        return throwable instanceof CloudException && (exception = (CloudException)throwable).body() != null && exception.body().code() != null && exception.body().code().equalsIgnoreCase("RoleAssignmentExists");
    }

    public static interface IdProvider {
        public String principalId();

        public String resourceId();
    }
}

