/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for
 * license information.
 *
 * Code generated by Microsoft (R) AutoRest Code Generator.
 */

package com.microsoft.azure.management.resources;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Error reponse indicates ARM is not able to process the incoming request. The
 * reason is provided in the error message.
 */
public class ErrorResponse {
    /**
     * Http status code.
     */
    @JsonProperty(value = "httpStatus")
    private String httpStatus;

    /**
     * Error code.
     */
    @JsonProperty(value = "errorCode")
    private String errorCode;

    /**
     * Error message indicating why the operation failed.
     */
    @JsonProperty(value = "errorMessage")
    private String errorMessage;

    /**
     * Get the httpStatus value.
     *
     * @return the httpStatus value
     */
    public String httpStatus() {
        return this.httpStatus;
    }

    /**
     * Set the httpStatus value.
     *
     * @param httpStatus the httpStatus value to set
     * @return the ErrorResponse object itself.
     */
    public ErrorResponse withHttpStatus(String httpStatus) {
        this.httpStatus = httpStatus;
        return this;
    }

    /**
     * Get the errorCode value.
     *
     * @return the errorCode value
     */
    public String errorCode() {
        return this.errorCode;
    }

    /**
     * Set the errorCode value.
     *
     * @param errorCode the errorCode value to set
     * @return the ErrorResponse object itself.
     */
    public ErrorResponse withErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    /**
     * Get the errorMessage value.
     *
     * @return the errorMessage value
     */
    public String errorMessage() {
        return this.errorMessage;
    }

    /**
     * Set the errorMessage value.
     *
     * @param errorMessage the errorMessage value to set
     * @return the ErrorResponse object itself.
     */
    public ErrorResponse withErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

}
