/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.resources.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.LongRunningFinalState;
import com.microsoft.azure.LongRunningOperationOptions;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.resources.ExportTemplateRequest;
import com.microsoft.azure.management.resources.ResourceGroupPatchable;
import com.microsoft.azure.management.resources.implementation.PageImpl;
import com.microsoft.azure.management.resources.implementation.ResourceGroupExportResultInner;
import com.microsoft.azure.management.resources.implementation.ResourceGroupInner;
import com.microsoft.azure.management.resources.implementation.ResourceManagementClientImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ResourceGroupsInner {
    private ResourceGroupsService service;
    private ResourceManagementClientImpl client;

    public ResourceGroupsInner(Retrofit retrofit, ResourceManagementClientImpl client) {
        this.service = (ResourceGroupsService)retrofit.create(ResourceGroupsService.class);
        this.client = client;
    }

    public boolean checkExistence(String resourceGroupName) {
        return (Boolean)((ServiceResponse)this.checkExistenceWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Boolean> checkExistenceAsync(String resourceGroupName, ServiceCallback<Boolean> serviceCallback) {
        return ServiceFuture.fromResponse(this.checkExistenceWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Boolean> checkExistenceAsync(String resourceGroupName) {
        return this.checkExistenceWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Boolean>, Boolean>(){

            public Boolean call(ServiceResponse<Boolean> response) {
                return (Boolean)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Boolean>> checkExistenceWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.checkExistence(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<Void>, Observable<ServiceResponse<Boolean>>>(){

            public Observable<ServiceResponse<Boolean>> call(Response<Void> response) {
                try {
                    ServiceResponse clientResponse = ResourceGroupsInner.this.checkExistenceDelegate((Response<Void>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Boolean> checkExistenceDelegate(Response<Void> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).register(404, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).buildEmpty(response);
    }

    public ResourceGroupInner createOrUpdate(String resourceGroupName, ResourceGroupInner parameters) {
        return (ResourceGroupInner)((Object)((ServiceResponse)this.createOrUpdateWithServiceResponseAsync(resourceGroupName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ResourceGroupInner> createOrUpdateAsync(String resourceGroupName, ResourceGroupInner parameters, ServiceCallback<ResourceGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createOrUpdateWithServiceResponseAsync(resourceGroupName, parameters), serviceCallback);
    }

    public Observable<ResourceGroupInner> createOrUpdateAsync(String resourceGroupName, ResourceGroupInner parameters) {
        return this.createOrUpdateWithServiceResponseAsync(resourceGroupName, parameters).map((Func1)new Func1<ServiceResponse<ResourceGroupInner>, ResourceGroupInner>(){

            public ResourceGroupInner call(ServiceResponse<ResourceGroupInner> response) {
                return (ResourceGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ResourceGroupInner>> createOrUpdateWithServiceResponseAsync(String resourceGroupName, ResourceGroupInner parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)((Object)parameters));
        return this.service.createOrUpdate(resourceGroupName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceGroupInner>>>(){

            public Observable<ServiceResponse<ResourceGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourceGroupsInner.this.createOrUpdateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceGroupInner> createOrUpdateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceGroupInner>(){}.getType()).register(201, new TypeToken<ResourceGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName).toBlocking().last()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName) {
        return this.deleteWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Observable<Response<ResponseBody>> observable = this.service.delete(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new TypeToken<Void>(){}.getType());
    }

    public void beginDelete(String resourceGroupName) {
        ((ServiceResponse)this.beginDeleteWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body();
    }

    public ServiceFuture<Void> beginDeleteAsync(String resourceGroupName, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginDeleteWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<Void> beginDeleteAsync(String resourceGroupName) {
        return this.beginDeleteWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> beginDeleteWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.beginDelete(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourceGroupsInner.this.beginDeleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> beginDeleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<Void>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ResourceGroupInner get(String resourceGroupName) {
        return (ResourceGroupInner)((Object)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName).toBlocking().single()).body());
    }

    public ServiceFuture<ResourceGroupInner> getAsync(String resourceGroupName, ServiceCallback<ResourceGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName), serviceCallback);
    }

    public Observable<ResourceGroupInner> getAsync(String resourceGroupName) {
        return this.getWithServiceResponseAsync(resourceGroupName).map((Func1)new Func1<ServiceResponse<ResourceGroupInner>, ResourceGroupInner>(){

            public ResourceGroupInner call(ServiceResponse<ResourceGroupInner> response) {
                return (ResourceGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ResourceGroupInner>> getWithServiceResponseAsync(String resourceGroupName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceGroupInner>>>(){

            public Observable<ServiceResponse<ResourceGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourceGroupsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceGroupInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ResourceGroupInner update(String resourceGroupName, ResourceGroupPatchable parameters) {
        return (ResourceGroupInner)((Object)((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, parameters).toBlocking().single()).body());
    }

    public ServiceFuture<ResourceGroupInner> updateAsync(String resourceGroupName, ResourceGroupPatchable parameters, ServiceCallback<ResourceGroupInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, parameters), serviceCallback);
    }

    public Observable<ResourceGroupInner> updateAsync(String resourceGroupName, ResourceGroupPatchable parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, parameters).map((Func1)new Func1<ServiceResponse<ResourceGroupInner>, ResourceGroupInner>(){

            public ResourceGroupInner call(ServiceResponse<ResourceGroupInner> response) {
                return (ResourceGroupInner)((Object)response.body());
            }
        });
    }

    public Observable<ServiceResponse<ResourceGroupInner>> updateWithServiceResponseAsync(String resourceGroupName, ResourceGroupPatchable parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.update(resourceGroupName, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceGroupInner>>>(){

            public Observable<ServiceResponse<ResourceGroupInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourceGroupsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceGroupInner> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceGroupInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ResourceGroupExportResultInner exportTemplate(String resourceGroupName, ExportTemplateRequest parameters) {
        return (ResourceGroupExportResultInner)((ServiceResponse)this.exportTemplateWithServiceResponseAsync(resourceGroupName, parameters).toBlocking().last()).body();
    }

    public ServiceFuture<ResourceGroupExportResultInner> exportTemplateAsync(String resourceGroupName, ExportTemplateRequest parameters, ServiceCallback<ResourceGroupExportResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.exportTemplateWithServiceResponseAsync(resourceGroupName, parameters), serviceCallback);
    }

    public Observable<ResourceGroupExportResultInner> exportTemplateAsync(String resourceGroupName, ExportTemplateRequest parameters) {
        return this.exportTemplateWithServiceResponseAsync(resourceGroupName, parameters).map((Func1)new Func1<ServiceResponse<ResourceGroupExportResultInner>, ResourceGroupExportResultInner>(){

            public ResourceGroupExportResultInner call(ServiceResponse<ResourceGroupExportResultInner> response) {
                return (ResourceGroupExportResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ResourceGroupExportResultInner>> exportTemplateWithServiceResponseAsync(String resourceGroupName, ExportTemplateRequest parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        Observable<Response<ResponseBody>> observable = this.service.exportTemplate(this.client.subscriptionId(), resourceGroupName, this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent());
        return this.client.getAzureClient().getPostOrDeleteResultAsync(observable, new LongRunningOperationOptions().withFinalStateVia(LongRunningFinalState.LOCATION), new TypeToken<ResourceGroupExportResultInner>(){}.getType());
    }

    public ResourceGroupExportResultInner beginExportTemplate(String resourceGroupName, ExportTemplateRequest parameters) {
        return (ResourceGroupExportResultInner)((ServiceResponse)this.beginExportTemplateWithServiceResponseAsync(resourceGroupName, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ResourceGroupExportResultInner> beginExportTemplateAsync(String resourceGroupName, ExportTemplateRequest parameters, ServiceCallback<ResourceGroupExportResultInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.beginExportTemplateWithServiceResponseAsync(resourceGroupName, parameters), serviceCallback);
    }

    public Observable<ResourceGroupExportResultInner> beginExportTemplateAsync(String resourceGroupName, ExportTemplateRequest parameters) {
        return this.beginExportTemplateWithServiceResponseAsync(resourceGroupName, parameters).map((Func1)new Func1<ServiceResponse<ResourceGroupExportResultInner>, ResourceGroupExportResultInner>(){

            public ResourceGroupExportResultInner call(ServiceResponse<ResourceGroupExportResultInner> response) {
                return (ResourceGroupExportResultInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ResourceGroupExportResultInner>> beginExportTemplateWithServiceResponseAsync(String resourceGroupName, ExportTemplateRequest parameters) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.beginExportTemplate(this.client.subscriptionId(), resourceGroupName, this.client.apiVersion(), parameters, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ResourceGroupExportResultInner>>>(){

            public Observable<ServiceResponse<ResourceGroupExportResultInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ResourceGroupsInner.this.beginExportTemplateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ResourceGroupExportResultInner> beginExportTemplateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ResourceGroupExportResultInner>(){}.getType()).register(202, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ResourceGroupInner> list() {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync().toBlocking().single();
        return new PagedList<ResourceGroupInner>((Page)response.body()){

            public Page<ResourceGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceGroupInner>> listAsync(ListOperationCallback<ResourceGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(String nextPageLink) {
                return ResourceGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceGroupInner>> listAsync() {
        return this.listWithServiceResponseAsync().map((Func1)new Func1<ServiceResponse<Page<ResourceGroupInner>>, Page<ResourceGroupInner>>(){

            public Page<ResourceGroupInner> call(ServiceResponse<Page<ResourceGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceGroupInner>>> listWithServiceResponseAsync() {
        return this.listSinglePageAsync().concatMap((Func1)new Func1<ServiceResponse<Page<ResourceGroupInner>>, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(ServiceResponse<Page<ResourceGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceGroupInner>>> listSinglePageAsync() {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        String filter = null;
        Integer top = null;
        return this.service.list(this.client.subscriptionId(), filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceGroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ResourceGroupInner> list(String filter, Integer top) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(filter, top).toBlocking().single();
        return new PagedList<ResourceGroupInner>((Page)response.body()){

            public Page<ResourceGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceGroupInner>> listAsync(String filter, Integer top, ListOperationCallback<ResourceGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(filter, top), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(String nextPageLink) {
                return ResourceGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceGroupInner>> listAsync(String filter, Integer top) {
        return this.listWithServiceResponseAsync(filter, top).map((Func1)new Func1<ServiceResponse<Page<ResourceGroupInner>>, Page<ResourceGroupInner>>(){

            public Page<ResourceGroupInner> call(ServiceResponse<Page<ResourceGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceGroupInner>>> listWithServiceResponseAsync(String filter, Integer top) {
        return this.listSinglePageAsync(filter, top).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceGroupInner>>, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(ServiceResponse<Page<ResourceGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceGroupInner>>> listSinglePageAsync(String filter, Integer top) {
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(this.client.subscriptionId(), filter, top, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceGroupsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceGroupInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ResourceGroupInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ResourceGroupInner>((Page)response.body()){

            public Page<ResourceGroupInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ResourceGroupsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ResourceGroupInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ResourceGroupInner>> serviceFuture, ListOperationCallback<ResourceGroupInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(String nextPageLink) {
                return ResourceGroupsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ResourceGroupInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ResourceGroupInner>>, Page<ResourceGroupInner>>(){

            public Page<ResourceGroupInner> call(ServiceResponse<Page<ResourceGroupInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceGroupInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ResourceGroupInner>>, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(ServiceResponse<Page<ResourceGroupInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ResourceGroupsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ResourceGroupInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ResourceGroupInner>>>>(){

            public Observable<ServiceResponse<Page<ResourceGroupInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ResourceGroupsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ResourceGroupInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ResourceGroupInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ResourceGroupsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.ResourceGroups checkExistence"})
        @HEAD(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}")
        public Observable<Response<Void>> checkExistence(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.ResourceGroups createOrUpdate"})
        @PUT(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}")
        public Observable<Response<ResponseBody>> createOrUpdate(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body ResourceGroupInner var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.ResourceGroups delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.ResourceGroups beginDelete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> beginDelete(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.ResourceGroups get"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Query(value="api-version") String var3, @Header(value="accept-language") String var4, @Header(value="User-Agent") String var5);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.ResourceGroups update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="subscriptionId") String var2, @Body ResourceGroupPatchable var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.ResourceGroups exportTemplate"})
        @POST(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/exportTemplate")
        public Observable<Response<ResponseBody>> exportTemplate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Body ExportTemplateRequest var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.ResourceGroups beginExportTemplate"})
        @POST(value="subscriptions/{subscriptionId}/resourcegroups/{resourceGroupName}/exportTemplate")
        public Observable<Response<ResponseBody>> beginExportTemplate(@Path(value="subscriptionId") String var1, @Path(value="resourceGroupName") String var2, @Query(value="api-version") String var3, @Body ExportTemplateRequest var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.ResourceGroups list"})
        @GET(value="subscriptions/{subscriptionId}/resourcegroups")
        public Observable<Response<ResponseBody>> list(@Path(value="subscriptionId") String var1, @Query(value="$filter") String var2, @Query(value="$top") Integer var3, @Query(value="api-version") String var4, @Header(value="accept-language") String var5, @Header(value="User-Agent") String var6);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.resources.ResourceGroups listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

