/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.servicebus.security;

import com.microsoft.azure.credentials.MSICredentials;
import com.microsoft.azure.servicebus.primitives.MessagingFactory;
import com.microsoft.azure.servicebus.security.SecurityToken;
import com.microsoft.azure.servicebus.security.SecurityTokenType;
import com.microsoft.azure.servicebus.security.TokenProvider;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedIdentityTokenProvider
extends TokenProvider {
    private static final Logger TRACE_LOGGER = LoggerFactory.getLogger(ManagedIdentityTokenProvider.class);

    @Override
    public CompletableFuture<SecurityToken> getSecurityTokenAsync(String audience) {
        CompletableFuture<SecurityToken> tokenGeneratingFuture = new CompletableFuture<SecurityToken>();
        MessagingFactory.INTERNAL_THREAD_POOL.execute(() -> {
            try {
                MSICredentials credentials = new MSICredentials();
                String rawToken = credentials.getToken("https://servicebus.azure.net/");
                Date expiry = SecurityToken.getExpirationDateTimeUtcFromToken(rawToken);
                tokenGeneratingFuture.complete(new SecurityToken(SecurityTokenType.JWT, audience, rawToken, Instant.now(), expiry.toInstant()));
            }
            catch (IOException e) {
                TRACE_LOGGER.info("ManagedIdentity token generation failed.", (Throwable)e);
                tokenGeneratingFuture.completeExceptionally(e);
            }
            catch (ParseException e) {
                TRACE_LOGGER.info("Could not parse the expiry time from the Managed Identity token string.", (Throwable)e);
                tokenGeneratingFuture.completeExceptionally(e);
            }
        });
        return tokenGeneratingFuture;
    }
}

