/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.javamsalruntime;

import com.microsoft.azure.javamsalruntime.ErrorHandle;
import com.microsoft.azure.javamsalruntime.MsalInteropException;
import com.microsoft.azure.javamsalruntime.MsalRuntimeFuture;
import com.microsoft.azure.javamsalruntime.MsalRuntimeInterop;
import com.microsoft.azure.javamsalruntime.MsalRuntimeResponseStatus;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class HandleBase
extends LongByReference
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(HandleBase.class);
    protected LongByReference msalRuntimeHandle;
    ReleaseMethod releaseMethod;
    private final HandleFinalizerThread HANDLE_FINALIZER_THREAD = new HandleFinalizerThread();

    HandleBase(ReleaseMethod releaseMethod) {
        this.msalRuntimeHandle = new LongByReference();
        this.releaseMethod = releaseMethod;
        this.HANDLE_FINALIZER_THREAD.addReference(this, this.msalRuntimeHandle, releaseMethod);
    }

    HandleBase(LongByReference msalRuntimeHandle, ReleaseMethod releaseMethod) {
        this.msalRuntimeHandle = msalRuntimeHandle;
        this.releaseMethod = releaseMethod;
        this.HANDLE_FINALIZER_THREAD.addReference(this, msalRuntimeHandle, releaseMethod);
    }

    public long value() {
        return this.getValue();
    }

    boolean isHandleValid() {
        return this.value() != 0L;
    }

    public void release() {
        if (this.isHandleValid()) {
            try {
                MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(this.releaseMethod.release(this.value()));
                this.msalRuntimeHandle = null;
            }
            catch (MsalInteropException e) {
                throw e;
            }
            catch (Exception e) {
                MsalRuntimeInterop.ERROR_HELPER.logUnknownErrorReleasingHandle(e);
            }
        }
    }

    @Override
    public void close() {
        this.release();
    }

    static String getString(HandleBase handle, GetMsalRuntimeString getMSALRuntimeString) {
        IntByReference bufferSize = new IntByReference(0);
        boolean insufficientBufferError = MsalRuntimeInterop.ERROR_HELPER.checkResponseStatus(getMSALRuntimeString.getString(handle, null, bufferSize), MsalRuntimeResponseStatus.MSALRUNTIME_RESPONSE_STATUS_INSUFFICIENTBUFFER);
        if (insufficientBufferError) {
            if (bufferSize.getValue() != 0) {
                Memory stringMemoryLocation = new Memory((long)(Native.WCHAR_SIZE * bufferSize.getValue()));
                MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(getMSALRuntimeString.getString(handle, (Pointer)stringMemoryLocation, bufferSize));
                return stringMemoryLocation.getWideString(0L);
            }
            LOG.warn("Buffer size is 0");
            return "";
        }
        LOG.warn("Could not parse string.");
        return "";
    }

    class HandleFinalizerThread
    extends Thread {
        private final Logger LOG = LoggerFactory.getLogger(HandleFinalizerThread.class);
        private ReferenceQueue<HandleBase> handleReferenceQueue = new ReferenceQueue();

        HandleFinalizerThread() {
            this.setDaemon(true);
        }

        void addReference(HandleBase handle, LongByReference msalRuntimeHandle, ReleaseMethod releaseMethod) {
            if (!HandleBase.this.HANDLE_FINALIZER_THREAD.isAlive()) {
                HandleBase.this.HANDLE_FINALIZER_THREAD.setUncaughtExceptionHandler((th, ex) -> {
                    this.LOG.error("Unexpected exception in HandleFinalizerThread with {} open async handles. Will attempt to cancel any async operations before stopping thread.", (Object)MsalRuntimeFuture.msalRuntimeFutures.size());
                    for (MsalRuntimeFuture future : MsalRuntimeFuture.msalRuntimeFutures.values()) {
                        future.cancelAsyncOperation();
                        future.handle.release();
                    }
                });
                HandleBase.this.HANDLE_FINALIZER_THREAD.start();
            }
            new HandleFinalizer(handle, msalRuntimeHandle, releaseMethod, this.handleReferenceQueue);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    HandleFinalizer handleFinalizer = (HandleFinalizer)this.handleReferenceQueue.remove();
                    this.LOG.info("Found Handle with no references, closing.");
                    handleFinalizer.release();
                }
            }
            catch (InterruptedException e) {
                this.LOG.error("HandleFinalizerThread interrupted with {} open async handles. Will attempt to cancel any async operations before stopping thread.", (Object)MsalRuntimeFuture.msalRuntimeFutures.size());
                for (MsalRuntimeFuture future : MsalRuntimeFuture.msalRuntimeFutures.values()) {
                    future.cancelAsyncOperation();
                    future.handle.release();
                }
                return;
            }
        }
    }

    class HandleFinalizer
    extends PhantomReference<HandleBase> {
        private final Logger LOG;
        private LongByReference finalizerMsalRuntimeHandle;
        private ReleaseMethod finalizerReleaseMethod;

        private HandleFinalizer(HandleBase handle, LongByReference msalRuntimeHandle, ReleaseMethod releaseMethod, ReferenceQueue<HandleBase> queue) {
            super(handle, queue);
            this.LOG = LoggerFactory.getLogger(HandleFinalizer.class);
            this.finalizerMsalRuntimeHandle = msalRuntimeHandle;
            this.finalizerReleaseMethod = releaseMethod;
        }

        private void release() {
            this.LOG.debug("Releasing a handle via PhantomReference");
            if (this.finalizerMsalRuntimeHandle != null && this.finalizerMsalRuntimeHandle.getValue() != 0L) {
                try {
                    MsalRuntimeInterop.ERROR_HELPER.checkMsalRuntimeError(this.finalizerReleaseMethod.release(this.finalizerMsalRuntimeHandle.getValue()));
                    this.finalizerMsalRuntimeHandle = null;
                }
                catch (MsalInteropException e) {
                    throw e;
                }
                catch (Exception e) {
                    MsalRuntimeInterop.ERROR_HELPER.logUnknownErrorReleasingHandle(e);
                }
            }
        }
    }

    @FunctionalInterface
    static interface GetMsalRuntimeString {
        public ErrorHandle getString(HandleBase var1, Pointer var2, IntByReference var3);
    }

    @FunctionalInterface
    static interface ReleaseMethod {
        public ErrorHandle release(long var1);
    }
}

