/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.msal4j;

import com.microsoft.aad.msal4j.IApiParameters;
import com.microsoft.aad.msal4j.ParameterValidationUtils;
import java.net.URI;
import java.util.Set;
import lombok.NonNull;

public class AuthorizationCodeParameters
implements IApiParameters {
    @NonNull
    private String authorizationCode;
    @NonNull
    private URI redirectUri;
    private Set<String> scopes;
    private String codeVerifier;

    private static AuthorizationCodeParametersBuilder builder() {
        return new AuthorizationCodeParametersBuilder();
    }

    public static AuthorizationCodeParametersBuilder builder(String authorizationCode, URI redirectUri) {
        ParameterValidationUtils.validateNotBlank("authorizationCode", authorizationCode);
        return AuthorizationCodeParameters.builder().authorizationCode(authorizationCode).redirectUri(redirectUri);
    }

    @NonNull
    public String authorizationCode() {
        return this.authorizationCode;
    }

    @NonNull
    public URI redirectUri() {
        return this.redirectUri;
    }

    @Override
    public Set<String> scopes() {
        return this.scopes;
    }

    public String codeVerifier() {
        return this.codeVerifier;
    }

    private AuthorizationCodeParameters(@NonNull String authorizationCode, @NonNull URI redirectUri, Set<String> scopes, String codeVerifier) {
        if (authorizationCode == null) {
            throw new NullPointerException("authorizationCode is marked @NonNull but is null");
        }
        if (redirectUri == null) {
            throw new NullPointerException("redirectUri is marked @NonNull but is null");
        }
        this.authorizationCode = authorizationCode;
        this.redirectUri = redirectUri;
        this.scopes = scopes;
        this.codeVerifier = codeVerifier;
    }

    public static class AuthorizationCodeParametersBuilder {
        private String authorizationCode;
        private URI redirectUri;
        private Set<String> scopes;
        private String codeVerifier;

        AuthorizationCodeParametersBuilder() {
        }

        public AuthorizationCodeParametersBuilder authorizationCode(String authorizationCode) {
            this.authorizationCode = authorizationCode;
            return this;
        }

        public AuthorizationCodeParametersBuilder redirectUri(URI redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public AuthorizationCodeParametersBuilder scopes(Set<String> scopes) {
            this.scopes = scopes;
            return this;
        }

        public AuthorizationCodeParametersBuilder codeVerifier(String codeVerifier) {
            this.codeVerifier = codeVerifier;
            return this;
        }

        public AuthorizationCodeParameters build() {
            return new AuthorizationCodeParameters(this.authorizationCode, this.redirectUri, this.scopes, this.codeVerifier);
        }

        public String toString() {
            return "AuthorizationCodeParameters.AuthorizationCodeParametersBuilder(authorizationCode=" + this.authorizationCode + ", redirectUri=" + this.redirectUri + ", scopes=" + this.scopes + ", codeVerifier=" + this.codeVerifier + ")";
        }
    }
}

