/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.serializer;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class FileUploadCompletionNotification {
    private static final String CORRELATION_ID_TAG = "correlationId";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="correlationId")
    private String correlationId = null;
    private static final String IS_SUCCESS_TAG = "isSuccess";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="isSuccess")
    private Boolean isSuccess = null;
    private static final String STATUS_CODE_TAG = "statusCode";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="statusCode")
    private Integer statusCode = null;
    private static final String STATUS_DESCRIPTION_TAG = "statusDescription";
    @Expose(serialize=true, deserialize=true)
    @SerializedName(value="statusDescription")
    private String statusDescription = null;

    public FileUploadCompletionNotification(String correlationId, Boolean isSuccess) {
        this.setCorrelationId(correlationId);
        this.updateStatus(isSuccess, this.statusCode, this.statusDescription);
    }

    public FileUploadCompletionNotification(String correlationId, Boolean isSuccess, Integer statusCode, String statusDescription) {
        this.setCorrelationId(correlationId);
        this.updateStatus(isSuccess, statusCode, statusDescription);
    }

    public FileUploadCompletionNotification(String json) {
        FileUploadCompletionNotification fileUploadCompletionNotification;
        Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
        try {
            fileUploadCompletionNotification = (FileUploadCompletionNotification)gson.fromJson(json, FileUploadCompletionNotification.class);
        }
        catch (Exception malformed) {
            throw new IllegalArgumentException("Malformed json", malformed);
        }
        this.correlationId = fileUploadCompletionNotification.getCorrelationId();
        this.isSuccess = fileUploadCompletionNotification.getSuccess();
        this.statusCode = fileUploadCompletionNotification.getStatusCode();
        this.statusDescription = fileUploadCompletionNotification.getStatusDescription();
    }

    private void updateStatus(Boolean isSuccess, Integer statusCode, String statusDescription) throws IllegalArgumentException {
        this.isSuccess = isSuccess;
        this.statusCode = statusCode;
        this.statusDescription = statusDescription;
    }

    public String toJson() {
        Gson gson = new GsonBuilder().disableHtmlEscaping().serializeNulls().create();
        return gson.toJson((Object)this);
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public Boolean getSuccess() {
        return this.isSuccess;
    }

    public void setSuccess(Boolean success) {
        this.isSuccess = success;
    }

    public Integer getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(Integer statusCode) {
        this.statusCode = statusCode;
    }

    public String getStatusDescription() {
        return this.statusDescription;
    }

    public void setStatusDescription(String statusDescription) {
        this.statusDescription = statusDescription;
    }

    public FileUploadCompletionNotification() {
    }
}

