/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.transport.amqp;

import com.microsoft.azure.sdk.iot.deps.transport.amqp.SaslHandler;
import org.apache.qpid.proton.engine.Sasl;
import org.apache.qpid.proton.engine.SaslListener;
import org.apache.qpid.proton.engine.Transport;

public class SaslListenerImpl
implements SaslListener {
    private SaslHandler saslHandler;
    private Exception savedException;
    private static final String PLAIN = "PLAIN";

    public SaslListenerImpl(SaslHandler saslHandler) {
        this.saslHandler = saslHandler;
    }

    public void onSaslMechanisms(Sasl sasl, Transport transport) {
        if (sasl == null) {
            this.savedException = new IllegalArgumentException("Sasl cannot be null");
        } else {
            String[] mechanisms = sasl.getRemoteMechanisms();
            String chosenMechanism = null;
            try {
                byte[] initMessage;
                chosenMechanism = this.saslHandler.chooseSaslMechanism(mechanisms);
                sasl.setMechanisms(new String[]{chosenMechanism});
                if (PLAIN.equalsIgnoreCase(chosenMechanism)) {
                    sasl.plain(this.saslHandler.getPlainUsername(), this.saslHandler.getPlainPassword());
                }
                if ((initMessage = this.saslHandler.getInitPayload(chosenMechanism)) != null && initMessage.length > 0) {
                    sasl.send(initMessage, 0, initMessage.length);
                }
            }
            catch (Exception e) {
                this.savedException = e;
            }
        }
    }

    public void onSaslChallenge(Sasl sasl, Transport transport) {
        if (sasl == null) {
            this.savedException = new IllegalArgumentException("Sasl cannot be null");
        } else {
            byte[] saslChallenge = new byte[sasl.pending()];
            sasl.recv(saslChallenge, 0, saslChallenge.length);
            try {
                byte[] challengeResponse = this.saslHandler.handleChallenge(saslChallenge);
                sasl.send(challengeResponse, 0, challengeResponse.length);
            }
            catch (Exception e) {
                this.savedException = e;
            }
        }
    }

    public void onSaslOutcome(Sasl sasl, Transport transport) {
        if (sasl == null) {
            this.savedException = new IllegalArgumentException("Sasl cannot be null");
        } else {
            try {
                switch (sasl.getOutcome()) {
                    case PN_SASL_TEMP: {
                        this.saslHandler.handleOutcome(SaslHandler.SaslOutcome.SYS_TEMP);
                        break;
                    }
                    case PN_SASL_PERM: {
                        this.saslHandler.handleOutcome(SaslHandler.SaslOutcome.SYS_PERM);
                        break;
                    }
                    case PN_SASL_AUTH: {
                        this.saslHandler.handleOutcome(SaslHandler.SaslOutcome.AUTH);
                        break;
                    }
                    case PN_SASL_OK: {
                        this.saslHandler.handleOutcome(SaslHandler.SaslOutcome.OK);
                        break;
                    }
                    case PN_SASL_NONE: {
                        throw new IllegalStateException("Sasl negotiation did not finish yet");
                    }
                    default: {
                        this.saslHandler.handleOutcome(SaslHandler.SaslOutcome.SYS);
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.savedException = e;
            }
        }
    }

    public Exception getSavedException() {
        return this.savedException;
    }

    public void onSaslResponse(Sasl sasl, Transport transport) {
    }

    public void onSaslInit(Sasl sasl, Transport transport) {
    }
}

