/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.util;

import java.util.Map;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class Tools {
    public static Boolean isNullOrEmpty(String value) {
        Boolean retVal = value == null ? Boolean.valueOf(true) : Boolean.valueOf(value.length() == 0);
        return retVal;
    }

    public static Boolean isNullOrWhiteSpace(String value) {
        Boolean retVal = value == null ? Boolean.valueOf(true) : Tools.isNullOrEmpty(value.trim());
        return retVal;
    }

    public static String getValueStringByKey(Map map, String keyName) {
        Object val;
        String retVal = map == null || keyName == null ? "" : ((val = map.get(keyName)) != null ? val.toString().trim() : "");
        return retVal;
    }

    public static String getValueFromJsonObject(JsonObject jsonObject, String key) {
        JsonValue jsonValue;
        String retVal = jsonObject == null || jsonObject == JsonObject.NULL || key == null || key.length() == 0 ? "" : ((jsonValue = (JsonValue)jsonObject.get((Object)key)) != JsonValue.NULL ? Tools.getValueFromJsonString(jsonObject.getJsonString(key)) : "");
        return retVal;
    }

    public static String getValueFromJsonString(JsonString jsonString) {
        String retVal;
        if (jsonString == null) {
            retVal = "";
        } else {
            retVal = jsonString.toString();
            if (retVal.startsWith("\"")) {
                retVal = retVal.replaceFirst("\"", "");
            }
            if (retVal.endsWith("\"")) {
                retVal = retVal.substring(0, retVal.length() - 1);
            }
        }
        return retVal;
    }

    public static long getNumberValueFromJsonObject(JsonObject jsonObject, String key) {
        JsonValue jsonValue;
        JsonNumber jsonNumber = null;
        long retVal = jsonObject == null || jsonObject == JsonObject.NULL || key == null || key.length() == 0 ? 0L : ((jsonValue = (JsonValue)jsonObject.get((Object)key)) != JsonValue.NULL ? ((jsonNumber = jsonObject.getJsonNumber(key)) != null ? jsonNumber.longValue() : 0L) : 0L);
        return retVal;
    }

    public static void appendJsonAttribute(StringBuilder strBuilder, String name, String value, Boolean isQuoted, Boolean isLast) {
        if (strBuilder != null) {
            strBuilder.append("\"");
            if (Tools.isNullOrEmpty(name).booleanValue()) {
                strBuilder.append("");
            } else {
                strBuilder.append(name);
            }
            strBuilder.append("\"");
            strBuilder.append(":");
            if (Tools.isNullOrEmpty(value).booleanValue()) {
                strBuilder.append("null");
            } else {
                if (isQuoted.booleanValue()) {
                    strBuilder.append("\"");
                }
                strBuilder.append(value);
                if (isQuoted.booleanValue()) {
                    strBuilder.append("\"");
                }
            }
            if (!isLast.booleanValue()) {
                strBuilder.append(",");
            }
        }
    }

    public static boolean areEqual(Object a, Object b) {
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }
}

