/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.deps.twin;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.microsoft.azure.sdk.iot.deps.serializer.ParserUtility;
import com.microsoft.azure.sdk.iot.deps.util.Tools;
import java.util.Date;
import java.util.Map;

public class TwinMetadata {
    public static final String LAST_UPDATE_TAG = "$lastUpdated";
    private Date lastUpdated;
    public static final String LAST_UPDATE_VERSION_TAG = "$lastUpdatedVersion";
    private final Integer lastUpdatedVersion;

    TwinMetadata(String lastUpdated, Integer lastUpdatedVersion) {
        if (!Tools.isNullOrEmpty(lastUpdated).booleanValue()) {
            this.lastUpdated = ParserUtility.getDateTimeUtc(lastUpdated);
        }
        this.lastUpdatedVersion = lastUpdatedVersion;
        if (this.lastUpdatedVersion == null && this.lastUpdated == null) {
            throw new IllegalArgumentException("no valid data to create a TwinMetadata.");
        }
    }

    TwinMetadata(TwinMetadata metadata) {
        if (metadata == null) {
            throw new IllegalArgumentException("metadata to copy cannot be null");
        }
        this.lastUpdated = metadata.getLastUpdated();
        this.lastUpdatedVersion = metadata.getLastUpdatedVersion();
    }

    protected static TwinMetadata tryExtractFromMap(Object metadata) {
        if (!(metadata instanceof Map)) {
            return null;
        }
        String lastUpdated = null;
        Integer lastUpdatedVersion = null;
        for (Map.Entry entry : ((Map)metadata).entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals(LAST_UPDATE_TAG)) {
                lastUpdated = (String)entry.getValue();
                continue;
            }
            if (!key.equals(LAST_UPDATE_VERSION_TAG)) continue;
            if (!(entry.getValue() instanceof Number)) {
                throw new IllegalArgumentException("Version in the metadata shall be a number");
            }
            lastUpdatedVersion = ((Number)entry.getValue()).intValue();
        }
        if (lastUpdatedVersion != null || !Tools.isNullOrEmpty(lastUpdated).booleanValue()) {
            return new TwinMetadata(lastUpdated, lastUpdatedVersion);
        }
        return null;
    }

    public Integer getLastUpdatedVersion() {
        return this.lastUpdatedVersion;
    }

    public Date getLastUpdated() {
        if (this.lastUpdated == null) {
            return null;
        }
        return new Date(this.lastUpdated.getTime());
    }

    protected JsonElement toJsonElement() {
        JsonObject jsonObject = new JsonObject();
        if (this.lastUpdated != null) {
            jsonObject.addProperty(LAST_UPDATE_TAG, ParserUtility.dateTimeUtcToString(this.lastUpdated));
        }
        if (this.lastUpdatedVersion != null) {
            jsonObject.addProperty(LAST_UPDATE_VERSION_TAG, (Number)this.lastUpdatedVersion);
        }
        return jsonObject;
    }

    public String toString() {
        return this.toJsonElement().toString();
    }
}

