/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStateCallback;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStatusChangeCallback;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStatusChangeReason;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.exceptions.DeviceClientException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubConnectionStatus;
import com.microsoft.azure.sdk.iot.device.transport.IotHubReceiveTask;
import com.microsoft.azure.sdk.iot.device.transport.IotHubSendTask;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransport;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeviceIO
implements IotHubConnectionStatusChangeCallback {
    private static final Logger log = LoggerFactory.getLogger(DeviceIO.class);
    private long sendPeriodInMilliseconds;
    private long receivePeriodInMilliseconds;
    private IotHubTransport transport;
    private DeviceClientConfig config;
    private IotHubSendTask sendTask = null;
    private IotHubReceiveTask receiveTask = null;
    private IotHubClientProtocol protocol = null;
    private ScheduledExecutorService receiveTaskScheduler;
    private ScheduledExecutorService sendTaskScheduler;
    private IotHubConnectionStatus state;
    private List<DeviceClientConfig> deviceClientConfigs = new LinkedList<DeviceClientConfig>();
    private Object stateLock = new Object();

    DeviceIO(DeviceClientConfig config, long sendPeriodInMilliseconds, long receivePeriodInMilliseconds) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null.");
        }
        this.deviceClientConfigs.add(config);
        this.config = config;
        this.protocol = this.config.getProtocol();
        this.sendPeriodInMilliseconds = sendPeriodInMilliseconds;
        this.receivePeriodInMilliseconds = receivePeriodInMilliseconds;
        this.state = IotHubConnectionStatus.DISCONNECTED;
        if (this.protocol == IotHubClientProtocol.AMQPS_WS || this.protocol == IotHubClientProtocol.MQTT_WS) {
            this.config.setUseWebsocket(true);
        }
        this.transport = new IotHubTransport(config, this);
        this.sendPeriodInMilliseconds = sendPeriodInMilliseconds;
        this.receivePeriodInMilliseconds = receivePeriodInMilliseconds;
        this.state = IotHubConnectionStatus.DISCONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void open() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.isOpen()) {
                return;
            }
            try {
                this.transport.open(this.deviceClientConfigs);
            }
            catch (DeviceClientException e) {
                throw new IOException("Could not open the connection", e);
            }
        }
    }

    void addClient(DeviceClientConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("Config cannot be null");
        }
        this.deviceClientConfigs.add(config);
    }

    private void startWorkerThreads() {
        this.sendTask = new IotHubSendTask(this.transport);
        this.receiveTask = new IotHubReceiveTask(this.transport);
        this.sendTaskScheduler = Executors.newScheduledThreadPool(1);
        this.receiveTaskScheduler = Executors.newScheduledThreadPool(1);
        this.sendTaskScheduler.scheduleAtFixedRate(this.sendTask, 0L, this.sendPeriodInMilliseconds, TimeUnit.MILLISECONDS);
        this.receiveTaskScheduler.scheduleAtFixedRate(this.receiveTask, 0L, this.receivePeriodInMilliseconds, TimeUnit.MILLISECONDS);
        this.state = IotHubConnectionStatus.CONNECTED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.sendTaskScheduler != null) {
                this.sendTaskScheduler.shutdown();
            }
            if (this.receiveTaskScheduler != null) {
                this.receiveTaskScheduler.shutdown();
            }
            try {
                this.transport.close(IotHubConnectionStatusChangeReason.CLIENT_CLOSE, null);
            }
            catch (DeviceClientException e) {
                this.state = IotHubConnectionStatus.DISCONNECTED;
                throw new IOException(e);
            }
            this.state = IotHubConnectionStatus.DISCONNECTED;
        }
    }

    public void multiplexClose() throws IOException {
        this.close();
    }

    public synchronized void sendEventAsync(Message message, IotHubEventCallback callback, Object callbackContext, String deviceId) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Cannot send event from an IoT Hub client that is closed.");
        }
        if (message == null) {
            throw new IllegalArgumentException("Cannot send message 'null'.");
        }
        if (deviceId != null) {
            message.setConnectionDeviceId(deviceId);
        }
        this.transport.addMessage(message, callback, callbackContext);
    }

    public long getReceivePeriodInMilliseconds() {
        return this.receivePeriodInMilliseconds;
    }

    public void setReceivePeriodInMilliseconds(long newIntervalInMilliseconds) throws IOException {
        if (newIntervalInMilliseconds <= 0L) {
            throw new IllegalArgumentException("receive interval can not be zero or negative");
        }
        this.receivePeriodInMilliseconds = newIntervalInMilliseconds;
        if (this.receiveTaskScheduler != null) {
            if (this.receiveTask == null) {
                throw new IOException("transport receive task not set");
            }
            this.receiveTaskScheduler.scheduleAtFixedRate(this.receiveTask, 0L, this.receivePeriodInMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    public long getSendPeriodInMilliseconds() {
        return this.sendPeriodInMilliseconds;
    }

    public void setSendPeriodInMilliseconds(long newIntervalInMilliseconds) throws IOException {
        if (newIntervalInMilliseconds <= 0L) {
            throw new IllegalArgumentException("send interval can not be zero or negative");
        }
        this.sendPeriodInMilliseconds = newIntervalInMilliseconds;
        if (this.sendTaskScheduler != null) {
            if (this.sendTask == null) {
                throw new IOException("transport send task not set");
            }
            this.sendTaskScheduler.scheduleAtFixedRate(this.sendTask, 0L, this.sendPeriodInMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    public IotHubClientProtocol getProtocol() {
        return this.protocol;
    }

    public boolean isOpen() {
        return this.state == IotHubConnectionStatus.CONNECTED || this.state == IotHubConnectionStatus.DISCONNECTED_RETRYING;
    }

    public boolean isEmpty() {
        return this.transport.isEmpty();
    }

    public void registerConnectionStateCallback(IotHubConnectionStateCallback callback, Object callbackContext) {
        this.transport.registerConnectionStateCallback(callback, callbackContext);
    }

    public void registerConnectionStatusChangeCallback(IotHubConnectionStatusChangeCallback statusChangeCallback, Object callbackContext) {
        this.transport.registerConnectionStatusChangeCallback(statusChangeCallback, callbackContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(IotHubConnectionStatus status, IotHubConnectionStatusChangeReason statusChangeReason, Throwable throwable, Object callbackContext) {
        Object object = this.stateLock;
        synchronized (object) {
            if (status == IotHubConnectionStatus.DISCONNECTED || status == IotHubConnectionStatus.DISCONNECTED_RETRYING) {
                if (this.sendTaskScheduler != null) {
                    this.sendTaskScheduler.shutdown();
                }
                if (this.receiveTaskScheduler != null) {
                    this.receiveTaskScheduler.shutdown();
                }
            } else if (status == IotHubConnectionStatus.CONNECTED) {
                this.startWorkerThreads();
            }
            this.state = status;
        }
    }
}

