/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.DeviceTwin;

import com.microsoft.azure.sdk.iot.deps.twin.TwinCollection;
import com.microsoft.azure.sdk.iot.deps.twin.TwinMetadata;
import com.microsoft.azure.sdk.iot.deps.twin.TwinState;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceIO;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceOperations;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.Pair;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.Property;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.PropertyCallBack;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.TwinPropertyCallBack;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.IotHubMessageResult;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeviceTwin {
    private static final Logger log = LoggerFactory.getLogger(DeviceTwin.class);
    private int requestId;
    private DeviceIO deviceIO = null;
    private DeviceClientConfig config = null;
    private boolean isSubscribed = false;
    private final Object DEVICE_TWIN_LOCK = new Object();
    private IotHubEventCallback deviceTwinStatusCallback;
    private Object deviceTwinStatusCallbackContext;
    private PropertyCallBack<String, Object> deviceTwinGenericPropertyChangeCallback;
    private TwinPropertyCallBack deviceTwinGenericTwinPropertyChangeCallback;
    private Object deviceTwinGenericPropertyChangeCallbackContext;
    private ConcurrentSkipListMap<String, Pair<PropertyCallBack<String, Object>, Object>> onDesiredPropertyChangeMap;
    private ConcurrentSkipListMap<String, Pair<TwinPropertyCallBack, Object>> onDesiredTwinPropertyChangeMap;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void OnDesiredPropertyChanged(TwinCollection desiredPropertyMap) {
        Object object = this.DEVICE_TWIN_LOCK;
        synchronized (object) {
            if (desiredPropertyMap != null) {
                Iterator desiredPropertyIt = desiredPropertyMap.entrySet().iterator();
                while (desiredPropertyIt.hasNext()) {
                    Map.Entry desiredProperty = (Map.Entry)desiredPropertyIt.next();
                    Property property = this.getProperty(desiredPropertyMap, (String)desiredProperty.getKey(), false);
                    if (!this.reportPropertyCallback(property)) {
                        this.reportDeviceTwinGenericPropertyCallback(property);
                    }
                    desiredPropertyIt.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void OnReportedPropertyChanged(TwinCollection reportedPropertyMap) {
        Object object = this.DEVICE_TWIN_LOCK;
        synchronized (object) {
            if (reportedPropertyMap != null) {
                Iterator reportedPropertyIt = reportedPropertyMap.entrySet().iterator();
                while (reportedPropertyIt.hasNext()) {
                    Map.Entry reportedProperty = (Map.Entry)reportedPropertyIt.next();
                    Property property = this.getProperty(reportedPropertyMap, (String)reportedProperty.getKey(), true);
                    if (this.deviceTwinGenericTwinPropertyChangeCallback != null) {
                        this.deviceTwinGenericTwinPropertyChangeCallback.TwinPropertyCallBack(property, this.deviceTwinGenericPropertyChangeCallbackContext);
                    }
                    reportedPropertyIt.remove();
                }
            }
        }
    }

    private Property getProperty(TwinCollection twinCollection, String key, boolean isReported) {
        Object value = twinCollection.get((Object)key);
        Integer propertyVersion = twinCollection.getVersionFinal();
        TwinMetadata metadata = twinCollection.getTwinMetadataFinal(key);
        Date lastUpdated = null;
        Integer lastUpdatedVersion = null;
        if (metadata != null) {
            lastUpdated = metadata.getLastUpdated();
            lastUpdatedVersion = metadata.getLastUpdatedVersion();
        }
        return new Property(key, value, propertyVersion, isReported, lastUpdated, lastUpdatedVersion);
    }

    public DeviceTwin(DeviceIO client, DeviceClientConfig config, IotHubEventCallback deviceTwinCallback, Object deviceTwinCallbackContext, PropertyCallBack genericPropertyCallback, Object genericPropertyCallbackContext) {
        this.deviceTwinInternal(client, config, deviceTwinCallback, deviceTwinCallbackContext, genericPropertyCallbackContext);
        this.deviceTwinGenericPropertyChangeCallback = genericPropertyCallback;
        this.deviceTwinGenericTwinPropertyChangeCallback = null;
    }

    public DeviceTwin(DeviceIO client, DeviceClientConfig config, IotHubEventCallback deviceTwinCallback, Object deviceTwinCallbackContext, TwinPropertyCallBack genericPropertyCallback, Object genericPropertyCallbackContext) {
        this.deviceTwinInternal(client, config, deviceTwinCallback, deviceTwinCallbackContext, genericPropertyCallbackContext);
        this.deviceTwinGenericTwinPropertyChangeCallback = genericPropertyCallback;
        this.deviceTwinGenericPropertyChangeCallback = null;
    }

    private void deviceTwinInternal(DeviceIO client, DeviceClientConfig config, IotHubEventCallback deviceTwinCallback, Object deviceTwinCallbackContext, Object genericPropertyCallbackContext) {
        if (client == null || config == null) {
            throw new IllegalArgumentException("Client or config cannot be null");
        }
        this.deviceIO = client;
        this.config = config;
        this.config.setDeviceTwinMessageCallback(new deviceTwinResponseMessageCallback(), null);
        this.requestId = 0;
        this.deviceTwinStatusCallback = deviceTwinCallback;
        this.deviceTwinStatusCallbackContext = deviceTwinCallbackContext;
        this.deviceTwinGenericPropertyChangeCallbackContext = genericPropertyCallbackContext;
    }

    public void getDeviceTwin() {
        this.checkSubscription();
        IotHubTransportMessage getTwinRequestMessage = new IotHubTransportMessage(new byte[0], MessageType.DEVICE_TWIN);
        getTwinRequestMessage.setRequestId(String.valueOf(this.requestId++));
        getTwinRequestMessage.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_GET_REQUEST);
        this.deviceIO.sendEventAsync(getTwinRequestMessage, new deviceTwinRequestMessageCallback(), null, this.config.getDeviceId());
    }

    public synchronized void updateReportedProperties(Set<Property> reportedProperties) throws IOException {
        this.updateReportedProperties(reportedProperties, null);
    }

    public synchronized void updateReportedProperties(Set<Property> reportedProperties, Integer version) throws IOException {
        if (reportedProperties == null) {
            throw new IllegalArgumentException("Reported properties cannot be null");
        }
        TwinCollection reportedPropertiesMap = new TwinCollection();
        for (Property p : reportedProperties) {
            if (reportedPropertiesMap.containsKey((Object)p.getKey())) {
                throw new IOException("Duplicate keys found in reported properties: " + p.getKey());
            }
            reportedPropertiesMap.putFinal(p.getKey(), p.getValue());
        }
        String serializedReportedProperties = reportedPropertiesMap.toJsonElement().toString();
        if (serializedReportedProperties == null) {
            return;
        }
        IotHubTransportMessage updateReportedPropertiesRequest = new IotHubTransportMessage(serializedReportedProperties.getBytes(), MessageType.DEVICE_TWIN);
        updateReportedPropertiesRequest.setConnectionDeviceId(this.config.getDeviceId());
        updateReportedPropertiesRequest.setRequestId(String.valueOf(this.requestId++));
        if (version != null) {
            updateReportedPropertiesRequest.setVersion(Integer.toString(version));
        }
        updateReportedPropertiesRequest.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_REQUEST);
        this.deviceIO.sendEventAsync(updateReportedPropertiesRequest, new deviceTwinRequestMessageCallback(), null, this.config.getDeviceId());
    }

    public void subscribeDesiredPropertiesNotification(Map<Property, Pair<PropertyCallBack<String, Object>, Object>> onDesiredPropertyChange) {
        if (this.onDesiredPropertyChangeMap == null) {
            this.onDesiredPropertyChangeMap = new ConcurrentSkipListMap();
        }
        if (onDesiredPropertyChange != null) {
            for (Map.Entry<Property, Pair<PropertyCallBack<String, Object>, Object>> desired : onDesiredPropertyChange.entrySet()) {
                this.onDesiredPropertyChangeMap.put(desired.getKey().getKey(), desired.getValue());
            }
        }
        this.checkSubscription();
    }

    public void subscribeDesiredPropertiesTwinPropertyNotification(Map<Property, Pair<TwinPropertyCallBack, Object>> onDesiredPropertyChange) {
        if (this.onDesiredTwinPropertyChangeMap == null) {
            this.onDesiredTwinPropertyChangeMap = new ConcurrentSkipListMap();
        }
        if (onDesiredPropertyChange != null) {
            for (Map.Entry<Property, Pair<TwinPropertyCallBack, Object>> desired : onDesiredPropertyChange.entrySet()) {
                this.onDesiredTwinPropertyChangeMap.put(desired.getKey().getKey(), desired.getValue());
            }
        }
        this.checkSubscription();
    }

    private void checkSubscription() {
        if (!this.isSubscribed) {
            IotHubTransportMessage desiredPropertiesNotificationRequest = new IotHubTransportMessage(new byte[0], MessageType.DEVICE_TWIN);
            desiredPropertiesNotificationRequest.setDeviceOperationType(DeviceOperations.DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_REQUEST);
            this.deviceIO.sendEventAsync(desiredPropertiesNotificationRequest, new deviceTwinRequestMessageCallback(), null, this.config.getDeviceId());
        }
    }

    private boolean reportPropertyCallback(Property property) {
        Pair<Object, Object> callBackObjectPair;
        boolean reported = false;
        if (this.onDesiredPropertyChangeMap != null && this.onDesiredPropertyChangeMap.containsKey(property.getKey()) && (callBackObjectPair = this.onDesiredPropertyChangeMap.get(property.getKey())) != null && callBackObjectPair.getKey() != null) {
            ((PropertyCallBack)callBackObjectPair.getKey()).PropertyCall(property.getKey(), property.getValue(), callBackObjectPair.getValue());
            reported = true;
        }
        if (this.onDesiredTwinPropertyChangeMap != null && this.onDesiredTwinPropertyChangeMap.containsKey(property.getKey()) && (callBackObjectPair = this.onDesiredTwinPropertyChangeMap.get(property.getKey())) != null && callBackObjectPair.getKey() != null) {
            ((TwinPropertyCallBack)callBackObjectPair.getKey()).TwinPropertyCallBack(property, callBackObjectPair.getValue());
            reported = true;
        }
        return reported;
    }

    private boolean reportDeviceTwinGenericPropertyCallback(Property property) {
        if (this.deviceTwinGenericPropertyChangeCallback != null) {
            this.deviceTwinGenericPropertyChangeCallback.PropertyCall(property.getKey(), property.getValue(), this.deviceTwinGenericPropertyChangeCallbackContext);
            return true;
        }
        if (this.deviceTwinGenericTwinPropertyChangeCallback != null) {
            this.deviceTwinGenericTwinPropertyChangeCallback.TwinPropertyCallBack(property, this.deviceTwinGenericPropertyChangeCallbackContext);
            return true;
        }
        return false;
    }

    private final class deviceTwinRequestMessageCallback
    implements IotHubEventCallback {
        private deviceTwinRequestMessageCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(IotHubStatusCode responseStatus, Object callbackContext) {
            Object object = DeviceTwin.this.DEVICE_TWIN_LOCK;
            synchronized (object) {
                if (responseStatus != IotHubStatusCode.OK && responseStatus != IotHubStatusCode.OK_EMPTY) {
                    DeviceTwin.this.deviceTwinStatusCallback.execute(responseStatus, DeviceTwin.this.deviceTwinStatusCallbackContext);
                }
            }
        }
    }

    private final class deviceTwinResponseMessageCallback
    implements MessageCallback {
        private deviceTwinResponseMessageCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IotHubMessageResult execute(Message message, Object callbackContext) {
            Object object = DeviceTwin.this.DEVICE_TWIN_LOCK;
            synchronized (object) {
                IotHubStatusCode iotHubStatus = IotHubStatusCode.ERROR;
                if (message.getMessageType() != MessageType.DEVICE_TWIN) {
                    System.out.print("Unexpected message type received");
                    DeviceTwin.this.deviceTwinStatusCallback.execute(iotHubStatus, DeviceTwin.this.deviceTwinStatusCallbackContext);
                    return IotHubMessageResult.ABANDON;
                }
                IotHubTransportMessage dtMessage = (IotHubTransportMessage)message;
                String status = dtMessage.getStatus();
                switch (dtMessage.getDeviceOperationType()) {
                    case DEVICE_OPERATION_TWIN_GET_RESPONSE: {
                        if (status != null) {
                            iotHubStatus = IotHubStatusCode.getIotHubStatusCode(Integer.parseInt(status));
                        }
                        log.trace("Executing twin callback for message {}", (Object)dtMessage);
                        DeviceTwin.this.deviceTwinStatusCallback.execute(iotHubStatus, DeviceTwin.this.deviceTwinStatusCallbackContext);
                        log.trace("Twin callback returned for message {}", (Object)dtMessage);
                        if (iotHubStatus != IotHubStatusCode.OK) break;
                        TwinState twinState = TwinState.createFromPropertiesJson((String)new String(dtMessage.getBytes(), Message.DEFAULT_IOTHUB_MESSAGE_CHARSET));
                        if (twinState.getDesiredProperty() != null) {
                            DeviceTwin.this.OnDesiredPropertyChanged(twinState.getDesiredProperty());
                        }
                        if (twinState.getReportedProperty() == null) break;
                        DeviceTwin.this.OnReportedPropertyChanged(twinState.getReportedProperty());
                        break;
                    }
                    case DEVICE_OPERATION_TWIN_UPDATE_REPORTED_PROPERTIES_RESPONSE: {
                        if (status != null) {
                            iotHubStatus = IotHubStatusCode.getIotHubStatusCode(Integer.parseInt(status));
                        }
                        log.trace("Executing twin status callback for device operation twin update reported properties response with status " + (Object)((Object)iotHubStatus));
                        DeviceTwin.this.deviceTwinStatusCallback.execute(iotHubStatus, DeviceTwin.this.deviceTwinStatusCallbackContext);
                        break;
                    }
                    case DEVICE_OPERATION_TWIN_SUBSCRIBE_DESIRED_PROPERTIES_RESPONSE: {
                        DeviceTwin.this.isSubscribed = true;
                        TwinState twinState = TwinState.createFromDesiredPropertyJson((String)new String(dtMessage.getBytes(), Message.DEFAULT_IOTHUB_MESSAGE_CHARSET));
                        if (twinState.getDesiredProperty() == null) break;
                        DeviceTwin.this.OnDesiredPropertyChanged(twinState.getDesiredProperty());
                        break;
                    }
                }
                return IotHubMessageResult.COMPLETE;
            }
        }
    }
}

