/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.ClientOptions;
import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.DeviceIO;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceMethod;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceMethodCallback;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.DeviceTwin;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.Pair;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.Property;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.PropertyCallBack;
import com.microsoft.azure.sdk.iot.device.DeviceTwin.TwinPropertyCallBack;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionStatusChangeCallback;
import com.microsoft.azure.sdk.iot.device.IotHubConnectionString;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageCallback;
import com.microsoft.azure.sdk.iot.device.ProductInfo;
import com.microsoft.azure.sdk.iot.device.ProxySettings;
import com.microsoft.azure.sdk.iot.device.auth.IotHubAuthenticationProvider;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.RetryPolicy;
import com.microsoft.azure.sdk.iot.provisioning.security.SecurityProvider;
import java.io.IOError;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalClient {
    private static final Logger log = LoggerFactory.getLogger(InternalClient.class);
    static final String SET_MINIMUM_POLLING_INTERVAL = "SetMinimumPollingInterval";
    static final String SET_RECEIVE_INTERVAL = "SetReceiveInterval";
    static final String SET_SEND_INTERVAL = "SetSendInterval";
    static final String SET_CERTIFICATE_PATH = "SetCertificatePath";
    static final String SET_CERTIFICATE_AUTHORITY = "SetCertificateAuthority";
    static final String SET_SAS_TOKEN_EXPIRY_TIME = "SetSASTokenExpiryTime";
    static final String SET_HTTPS_CONNECT_TIMEOUT = "SetHttpsConnectTimeout";
    static final String SET_HTTPS_READ_TIMEOUT = "SetHttpsReadTimeout";
    DeviceClientConfig config;
    DeviceIO deviceIO;
    private DeviceTwin twin;
    private DeviceMethod method;

    InternalClient(IotHubConnectionString iotHubConnectionString, IotHubClientProtocol protocol, long sendPeriodMillis, long receivePeriodMillis, ClientOptions clientOptions) {
        this.commonConstructorVerification(iotHubConnectionString, protocol);
        this.config = new DeviceClientConfig(iotHubConnectionString, clientOptions);
        this.config.setProtocol(protocol);
        if (clientOptions != null) {
            this.config.modelId = clientOptions.getModelId();
        }
        this.deviceIO = new DeviceIO(this.config, sendPeriodMillis, receivePeriodMillis);
    }

    InternalClient(IotHubAuthenticationProvider iotHubAuthenticationProvider, IotHubClientProtocol protocol, long sendPeriodMillis, long receivePeriodMillis) throws IOException, TransportException {
        this.config = new DeviceClientConfig(iotHubAuthenticationProvider);
        this.config.setProtocol(protocol);
        this.deviceIO = new DeviceIO(this.config, sendPeriodMillis, receivePeriodMillis);
    }

    InternalClient(IotHubConnectionString iotHubConnectionString, IotHubClientProtocol protocol, String publicKeyCertificate, boolean isCertificatePath, String privateKey, boolean isPrivateKeyPath, long sendPeriodMillis, long receivePeriodMillis) throws URISyntaxException {
        this.commonConstructorVerification(iotHubConnectionString, protocol);
        this.config = new DeviceClientConfig(iotHubConnectionString, publicKeyCertificate, isCertificatePath, privateKey, isPrivateKeyPath);
        this.config.setProtocol(protocol);
        this.deviceIO = new DeviceIO(this.config, sendPeriodMillis, receivePeriodMillis);
    }

    InternalClient(IotHubConnectionString iotHubConnectionString, IotHubClientProtocol protocol, SSLContext sslContext, long sendPeriodMillis, long receivePeriod) {
        this.commonConstructorVerification(iotHubConnectionString, protocol);
        this.config = new DeviceClientConfig(iotHubConnectionString, sslContext);
        this.config.setProtocol(protocol);
        this.deviceIO = new DeviceIO(this.config, sendPeriodMillis, receivePeriod);
    }

    InternalClient(String uri, String deviceId, SecurityProvider securityProvider, IotHubClientProtocol protocol, long sendPeriodMillis, long receivePeriodMillis, ClientOptions clientOptions) throws URISyntaxException, IOException {
        if (protocol == null) {
            throw new IllegalArgumentException("The transport protocol cannot be null");
        }
        if (securityProvider == null) {
            throw new IllegalArgumentException("securityProvider cannot be null");
        }
        if (uri == null || uri.isEmpty()) {
            throw new IllegalArgumentException("URI cannot be null or empty");
        }
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("deviceId cannot be null or empty");
        }
        IotHubConnectionString connectionString = new IotHubConnectionString(uri, deviceId, null, null);
        this.config = new DeviceClientConfig(connectionString, securityProvider);
        this.config.setProtocol(protocol);
        if (clientOptions != null) {
            this.config.modelId = clientOptions.getModelId();
        }
        this.deviceIO = new DeviceIO(this.config, sendPeriodMillis, receivePeriodMillis);
    }

    InternalClient() {
        this.config = null;
        this.deviceIO = null;
    }

    public void open() throws IOException {
        if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN && this.config.getSasTokenAuthentication().isRenewalNecessary()) {
            throw new SecurityException("Your SasToken is expired");
        }
        this.deviceIO.open();
    }

    public void close() throws IOException {
        while (!this.deviceIO.isEmpty()) {
        }
        this.deviceIO.close();
    }

    public void closeNow() throws IOException {
        this.deviceIO.close();
    }

    public void sendEventAsync(Message message, IotHubEventCallback callback, Object callbackContext) {
        message.setConnectionDeviceId(this.config.getDeviceId());
        this.deviceIO.sendEventAsync(message, callback, callbackContext, this.config.getDeviceId());
    }

    public void subscribeToDesiredProperties(Map<Property, Pair<PropertyCallBack<String, Object>, Object>> onDesiredPropertyChange) throws IOException {
        if (this.twin == null) {
            throw new IOException("Start twin before using it");
        }
        if (!this.deviceIO.isOpen()) {
            throw new IOException("Open the client connection before using it.");
        }
        this.twin.subscribeDesiredPropertiesNotification(onDesiredPropertyChange);
    }

    public void subscribeToTwinDesiredProperties(Map<Property, Pair<TwinPropertyCallBack, Object>> onDesiredPropertyChange) throws IOException {
        if (this.twin == null) {
            throw new IOException("Start twin before using it");
        }
        if (!this.deviceIO.isOpen()) {
            throw new IOException("Open the client connection before using it.");
        }
        this.twin.subscribeDesiredPropertiesTwinPropertyNotification(onDesiredPropertyChange);
    }

    public void sendReportedProperties(Set<Property> reportedProperties) throws IOException, IllegalArgumentException {
        if (this.twin == null) {
            throw new IOException("Start twin before using it");
        }
        if (!this.deviceIO.isOpen()) {
            throw new IOException("Open the client connection before using it.");
        }
        if (reportedProperties == null || reportedProperties.isEmpty()) {
            throw new IllegalArgumentException("Reported properties set cannot be null or empty.");
        }
        this.twin.updateReportedProperties(reportedProperties);
    }

    public void sendReportedProperties(Set<Property> reportedProperties, int version) throws IOException, IllegalArgumentException {
        if (this.twin == null) {
            throw new IOException("Start twin before using it");
        }
        if (!this.deviceIO.isOpen()) {
            throw new IOException("Open the client connection before using it.");
        }
        if (reportedProperties == null || reportedProperties.isEmpty()) {
            throw new IllegalArgumentException("Reported properties set cannot be null or empty.");
        }
        if (version < 0) {
            throw new IllegalArgumentException("Version cannot be null.");
        }
        this.twin.updateReportedProperties(reportedProperties, version);
    }

    public void registerConnectionStatusChangeCallback(IotHubConnectionStatusChangeCallback callback, Object callbackContext) throws IllegalArgumentException {
        this.deviceIO.registerConnectionStatusChangeCallback(callback, callbackContext);
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.config.setRetryPolicy(retryPolicy);
    }

    public void setOperationTimeout(long timeout) throws IllegalArgumentException {
        this.config.setOperationTimeout(timeout);
    }

    public ProductInfo getProductInfo() {
        return this.config.getProductInfo();
    }

    public DeviceClientConfig getConfig() {
        return this.config;
    }

    public void setOption(String optionName, Object value) {
        if (optionName == null) {
            throw new IllegalArgumentException("optionName is null");
        }
        if (value == null) {
            throw new IllegalArgumentException("optionName is null");
        }
        switch (optionName) {
            case "SetMinimumPollingInterval": 
            case "SetReceiveInterval": {
                if (this.deviceIO.isOpen()) {
                    throw new IllegalStateException("setOption " + optionName + " only works when the transport is closed");
                }
                this.setOption_SetMinimumPollingInterval(value);
                break;
            }
            case "SetSendInterval": {
                this.setOption_SetSendInterval(value);
                break;
            }
            case "SetCertificatePath": {
                if (this.deviceIO != null && this.deviceIO.isOpen()) {
                    throw new IllegalStateException("setOption SetCertificatePath only works when the transport is closed");
                }
                if (this.deviceIO.getProtocol() != IotHubClientProtocol.HTTPS) {
                    this.setOption_SetCertificatePath(value);
                    break;
                }
                throw new IllegalArgumentException("option SetCertificatePath cannot be invoked when using HTTPS protocol");
            }
            case "SetCertificateAuthority": {
                if (this.deviceIO != null && this.deviceIO.isOpen()) {
                    throw new IllegalStateException("setOption SetCertificatePath only works when the transport is closed");
                }
                this.setTrustedCertificates((String)value);
                break;
            }
            case "SetSASTokenExpiryTime": {
                this.setOption_SetSASTokenExpiryTime(value);
                break;
            }
            case "SetHttpsConnectTimeout": {
                this.setOption_SetHttpsConnectTimeout(value);
                break;
            }
            case "SetHttpsReadTimeout": {
                this.setOption_SetHttpsReadTimeout(value);
                break;
            }
            default: {
                throw new IllegalArgumentException("optionName is unknown = " + optionName);
            }
        }
    }

    void startTwinInternal(IotHubEventCallback twinStatusCallback, Object twinStatusCallbackContext, PropertyCallBack genericPropertyCallBack, Object genericPropertyCallBackContext) throws IOException, IllegalArgumentException, UnsupportedOperationException {
        if (!this.deviceIO.isOpen()) {
            throw new IOException("Open the client connection before using it.");
        }
        if (twinStatusCallback == null || genericPropertyCallBack == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        if (this.twin != null) {
            throw new UnsupportedOperationException("You have already initialised twin");
        }
        this.twin = new DeviceTwin(this.deviceIO, this.config, twinStatusCallback, twinStatusCallbackContext, genericPropertyCallBack, genericPropertyCallBackContext);
        this.twin.getDeviceTwin();
    }

    void startTwinInternal(IotHubEventCallback twinStatusCallback, Object twinStatusCallbackContext, TwinPropertyCallBack genericPropertyCallBack, Object genericPropertyCallBackContext) throws IOException, IllegalArgumentException, UnsupportedOperationException {
        if (!this.deviceIO.isOpen()) {
            throw new IOException("Open the client connection before using it.");
        }
        if (twinStatusCallback == null || genericPropertyCallBack == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        if (this.twin != null) {
            throw new UnsupportedOperationException("You have already initialised twin");
        }
        this.twin = new DeviceTwin(this.deviceIO, this.config, twinStatusCallback, twinStatusCallbackContext, genericPropertyCallBack, genericPropertyCallBackContext);
        this.twin.getDeviceTwin();
    }

    void getTwinInternal() throws IOException {
        if (this.twin == null) {
            throw new IOException("Start twin before using it");
        }
        if (!this.deviceIO.isOpen()) {
            throw new IOException("Open the client connection before using it.");
        }
        this.twin.getDeviceTwin();
    }

    void setMessageCallbackInternal(MessageCallback callback, Object context) {
        if (callback == null && context != null) {
            throw new IllegalArgumentException("Cannot give non-null context for a null callback.");
        }
        this.config.setMessageCallback(callback, context);
    }

    void subscribeToMethodsInternal(DeviceMethodCallback methodCallback, Object methodCallbackContext, IotHubEventCallback methodStatusCallback, Object methodStatusCallbackContext) throws IOException {
        if (!this.deviceIO.isOpen()) {
            throw new IOException("Open the client connection before using it.");
        }
        if (methodCallback == null || methodStatusCallback == null) {
            throw new IllegalArgumentException("Callback cannot be null");
        }
        if (this.method == null) {
            this.method = new DeviceMethod(this.deviceIO, this.config, methodStatusCallback, methodStatusCallbackContext);
        }
        this.method.subscribeToDeviceMethod(methodCallback, methodCallbackContext);
    }

    DeviceIO getDeviceIO() {
        return this.deviceIO;
    }

    void setDeviceIO(DeviceIO deviceIO) {
        this.deviceIO = deviceIO;
    }

    void setOption_SetCertificatePath(Object value) {
        if (value != null) {
            this.config.getAuthenticationProvider().setPathToIotHubTrustedCert((String)value);
        }
    }

    void setOption_SetHttpsConnectTimeout(Object value) {
        if (value != null) {
            if (this.config.getProtocol() != IotHubClientProtocol.HTTPS) {
                throw new UnsupportedOperationException("Cannot set the https connect timeout when using protocol " + (Object)((Object)this.config.getProtocol()));
            }
            if (value instanceof Integer) {
                this.config.setHttpsConnectTimeout((Integer)value);
            } else {
                throw new IllegalArgumentException("value is not int = " + value);
            }
        }
    }

    void setOption_SetHttpsReadTimeout(Object value) {
        if (value != null) {
            if (this.config.getProtocol() != IotHubClientProtocol.HTTPS) {
                throw new UnsupportedOperationException("Cannot set the https read timeout when using protocol " + (Object)((Object)this.config.getProtocol()));
            }
            if (value instanceof Integer) {
                this.config.setHttpsReadTimeout((Integer)value);
            } else {
                throw new IllegalArgumentException("value is not int = " + value);
            }
        }
    }

    void setTrustedCertificates(String certificates) {
        this.config.getAuthenticationProvider().setIotHubTrustedCert(certificates);
    }

    void setOption_SetSendInterval(Object value) {
        if (value != null) {
            if (value instanceof Long) {
                try {
                    this.deviceIO.setSendPeriodInMilliseconds((Long)value);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            } else {
                throw new IllegalArgumentException("value is not long = " + value);
            }
        }
    }

    void setOption_SetMinimumPollingInterval(Object value) {
        if (value != null) {
            if (value instanceof Long) {
                try {
                    this.deviceIO.setReceivePeriodInMilliseconds((Long)value);
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            } else {
                throw new IllegalArgumentException("value is not long = " + value);
            }
        }
    }

    void setOption_SetSASTokenExpiryTime(Object value) {
        if (this.config.getAuthenticationType() != DeviceClientConfig.AuthType.SAS_TOKEN) {
            throw new IllegalStateException("Cannot set sas token validity time when not using sas token authentication");
        }
        if (value != null) {
            if (!(value instanceof Long)) {
                throw new IllegalArgumentException("value is not long = " + value);
            }
            long validTimeInSeconds = (Long)value;
            this.config.getSasTokenAuthentication().setTokenValidSecs(validTimeInSeconds);
            if (this.deviceIO != null && this.deviceIO.isOpen()) {
                try {
                    if (this.config.getSasTokenAuthentication().canRefreshToken()) {
                        this.deviceIO.close();
                        this.deviceIO.open();
                    }
                }
                catch (IOException e) {
                    throw new IOError(e);
                }
            }
        }
    }

    public void setProxySettings(ProxySettings proxySettings) {
        if (this.deviceIO.isOpen()) {
            throw new IllegalStateException("Cannot set proxy after connection was already opened");
        }
        IotHubClientProtocol protocol = this.deviceIO.getProtocol();
        if (protocol != IotHubClientProtocol.HTTPS && protocol != IotHubClientProtocol.AMQPS_WS && protocol != IotHubClientProtocol.MQTT_WS) {
            throw new IllegalArgumentException("Use of proxies is unsupported unless using HTTPS, MQTT_WS or AMQPS_WS");
        }
        this.config.setProxy(proxySettings);
    }

    private void commonConstructorVerification(IotHubConnectionString connectionString, IotHubClientProtocol protocol) {
        if (connectionString == null) {
            throw new IllegalArgumentException("Connection string cannot be null");
        }
        if (protocol == null) {
            throw new IllegalArgumentException("Protocol cannot be null.");
        }
        String gatewayHostName = connectionString.getGatewayHostName();
        if (gatewayHostName != null && !gatewayHostName.isEmpty() && protocol == IotHubClientProtocol.HTTPS) {
            throw new UnsupportedOperationException("Communication with edgehub only supported by MQTT/MQTT_WS and AMQPS/AMQPS_WS");
        }
    }
}

