/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device;

import com.microsoft.azure.sdk.iot.device.DeviceClient;
import com.microsoft.azure.sdk.iot.device.DeviceIO;
import com.microsoft.azure.sdk.iot.device.IotHubClientProtocol;
import com.microsoft.azure.sdk.iot.device.transport.RetryPolicy;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransportClient {
    private static final Logger log = LoggerFactory.getLogger(TransportClient.class);
    public static long SEND_PERIOD_MILLIS = 10L;
    public static long RECEIVE_PERIOD_MILLIS_AMQPS = 10L;
    private IotHubClientProtocol iotHubClientProtocol;
    private DeviceIO deviceIO;
    private TransportClientState transportClientState;
    private ArrayList<DeviceClient> deviceClientList;

    public TransportClient(IotHubClientProtocol protocol) {
        switch (protocol) {
            case AMQPS: 
            case AMQPS_WS: {
                break;
            }
            case MQTT: 
            case MQTT_WS: 
            case HTTPS: {
                throw new IllegalArgumentException("Multiplexing is only supported for AMQPS and AMQPS_WS");
            }
            default: {
                throw new IllegalStateException("Invalid client protocol specified.");
            }
        }
        this.iotHubClientProtocol = protocol;
        this.deviceIO = null;
        this.deviceClientList = new ArrayList();
        this.transportClientState = TransportClientState.CLOSED;
    }

    public void open() throws IllegalStateException, IOException {
        if (this.deviceIO != null && this.deviceIO.isOpen()) {
            throw new IllegalStateException("The transport client connection is already open.");
        }
        if (this.deviceClientList.size() > 0) {
            this.deviceIO = new DeviceIO(this.deviceClientList.get(0).getConfig(), SEND_PERIOD_MILLIS, RECEIVE_PERIOD_MILLIS_AMQPS);
            this.deviceClientList.get(0).setDeviceIO(this.deviceIO);
            for (int i = 1; i < this.deviceClientList.size(); ++i) {
                this.deviceClientList.get(i).setDeviceIO(this.deviceIO);
                this.deviceIO.addClient(this.deviceClientList.get(i).getConfig());
            }
            this.deviceIO.open();
        }
        this.transportClientState = TransportClientState.OPENED;
        log.info("Transport client opened successfully");
    }

    public void closeNow() throws IOException {
        for (int i = 0; i < this.deviceClientList.size(); ++i) {
            this.deviceClientList.get(i).closeFileUpload();
        }
        if (this.deviceIO != null) {
            this.deviceIO.multiplexClose();
            this.deviceIO = null;
        }
        log.info("Transport client closed successfully");
    }

    public void setSendInterval(long newIntervalInMilliseconds) throws IOException {
        if (newIntervalInMilliseconds <= 0L) {
            throw new IllegalArgumentException("send interval can not be zero or negative");
        }
        if (this.transportClientState != TransportClientState.OPENED || this.deviceIO == null) {
            throw new IllegalStateException("TransportClient.setSendInterval only works when the transport client is opened");
        }
        this.deviceIO.setSendPeriodInMilliseconds(newIntervalInMilliseconds);
        log.debug("Send interval updated successfully in the transport client");
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        if (this.deviceClientList.size() == 0) {
            throw new UnsupportedOperationException("TransportClient.setRetryPolicy only works when there is at least one registered device client.");
        }
        for (int i = 0; i < this.deviceClientList.size(); ++i) {
            this.deviceClientList.get(i).getConfig().setRetryPolicy(retryPolicy);
        }
        log.debug("Retry policy updated successfully in the transport client");
    }

    void registerDeviceClient(DeviceClient deviceClient) throws IllegalArgumentException, IllegalStateException {
        if (deviceClient == null) {
            throw new IllegalArgumentException("deviceClient parameter cannot be null.");
        }
        if (this.deviceIO != null && this.deviceIO.isOpen()) {
            throw new IllegalStateException("deviceClient cannot be registered if the connection is open.");
        }
        this.deviceClientList.add(deviceClient);
        log.debug("DeviceClient instance successfully added to the transport client");
    }

    IotHubClientProtocol getIotHubClientProtocol() {
        return this.iotHubClientProtocol;
    }

    TransportClientState getTransportClientState() {
        return this.transportClientState;
    }

    public static enum TransportClientState {
        CLOSED,
        OPENED;

    }
}

