/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.auth;

import com.microsoft.azure.sdk.iot.deps.auth.IotHubSSLContext;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;

public abstract class IotHubAuthenticationProvider {
    protected String hostname;
    protected String gatewayHostname;
    protected String deviceId;
    protected String moduleId;
    protected IotHubSSLContext iotHubSSLContext;
    protected boolean sslContextNeedsUpdate;
    protected String iotHubTrustedCert;
    protected String pathToIotHubTrustedCert;

    public IotHubAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId) {
        if (hostname == null || hostname.isEmpty()) {
            throw new IllegalArgumentException("hostname cannot be null");
        }
        if (deviceId == null || deviceId.isEmpty()) {
            throw new IllegalArgumentException("deviceId cannot be null");
        }
        this.hostname = hostname;
        this.gatewayHostname = gatewayHostname;
        this.deviceId = deviceId;
        this.moduleId = moduleId;
    }

    public IotHubAuthenticationProvider(String hostname, String gatewayHostname, String deviceId, String moduleId, SSLContext sslContext) {
        this(hostname, gatewayHostname, deviceId, moduleId);
        this.sslContextNeedsUpdate = false;
        this.iotHubSSLContext = new IotHubSSLContext(sslContext);
    }

    public SSLContext getSSLContext() throws IOException {
        try {
            if (this.iotHubSSLContext == null || this.sslContextNeedsUpdate) {
                this.iotHubSSLContext = this.generateSSLContext();
                this.sslContextNeedsUpdate = false;
            }
            return this.iotHubSSLContext.getSSLContext();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            throw new IOException(e);
        }
    }

    public void setPathToIotHubTrustedCert(String pathToCertificate) {
        if (this.pathToIotHubTrustedCert == null || !this.pathToIotHubTrustedCert.equals(pathToCertificate)) {
            this.sslContextNeedsUpdate = true;
        }
        this.pathToIotHubTrustedCert = pathToCertificate;
    }

    public void setIotHubTrustedCert(String certificate) {
        if (this.iotHubTrustedCert == null || !this.iotHubTrustedCert.equals(certificate)) {
            this.sslContextNeedsUpdate = true;
        }
        this.iotHubTrustedCert = certificate;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getGatewayHostname() {
        return this.gatewayHostname;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getModuleId() {
        return this.moduleId;
    }

    public String getIotHubTrustedCert() {
        return this.iotHubTrustedCert;
    }

    public String getPathToIotHubTrustedCert() {
        return this.pathToIotHubTrustedCert;
    }

    private IotHubSSLContext generateSSLContext() throws IOException, CertificateException, NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        if (this.iotHubTrustedCert != null) {
            return new IotHubSSLContext(this.iotHubTrustedCert, false);
        }
        if (this.pathToIotHubTrustedCert != null) {
            return new IotHubSSLContext(this.pathToIotHubTrustedCert, true);
        }
        return new IotHubSSLContext();
    }
}

