/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.fileupload;

import com.microsoft.azure.sdk.iot.deps.serializer.FileUploadCompletionNotification;
import com.microsoft.azure.sdk.iot.deps.serializer.FileUploadSasUriRequest;
import com.microsoft.azure.sdk.iot.deps.serializer.FileUploadSasUriResponse;
import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.IotHubMethod;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.ResponseMessage;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsTransportManager;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUploadTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(FileUploadTask.class);
    private static final Charset DEFAULT_IOTHUB_MESSAGE_CHARSET = StandardCharsets.UTF_8;
    private HttpsTransportManager httpsTransportManager;
    private String blobName;
    private InputStream inputStream;
    private long streamLength;
    private IotHubEventCallback userCallback;
    private Object userCallbackContext;
    private static final String THREAD_NAME = "azure-iot-sdk-FileUploadTask";

    FileUploadTask(String blobName, InputStream inputStream, long streamLength, HttpsTransportManager httpsTransportManager, IotHubEventCallback userCallback, Object userCallbackContext) throws IllegalArgumentException {
        if (blobName == null || blobName.isEmpty()) {
            throw new IllegalArgumentException("blobName is null or empty");
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream is null or empty");
        }
        if (streamLength < 0L) {
            throw new IllegalArgumentException("streamLength is negative");
        }
        if (httpsTransportManager == null) {
            throw new IllegalArgumentException("httpsTransportManager is null");
        }
        if (userCallback == null) {
            throw new IllegalArgumentException("statusCallback is null");
        }
        this.blobName = blobName;
        this.inputStream = inputStream;
        this.streamLength = streamLength;
        this.userCallback = userCallback;
        this.userCallbackContext = userCallbackContext;
        this.httpsTransportManager = httpsTransportManager;
        log.trace("HttpsFileUpload object is created successfully");
    }

    public FileUploadTask(HttpsTransportManager httpsTransportManager) {
        this.httpsTransportManager = httpsTransportManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        FileUploadCompletionNotification fileUploadCompletionNotification;
        block14: {
            Thread.currentThread().setName(THREAD_NAME);
            fileUploadCompletionNotification = null;
            FileUploadSasUriResponse sasUriResponse = null;
            try {
                sasUriResponse = this.getFileUploadSasUri(new FileUploadSasUriRequest(this.blobName));
            }
            catch (IOException | IllegalArgumentException e) {
                log.error("File upload failed to get a SAS URI from Iot Hub", (Throwable)e);
                this.userCallback.execute(IotHubStatusCode.ERROR, this.userCallbackContext);
                return;
            }
            CloudBlockBlob blob = new CloudBlockBlob(sasUriResponse.getBlobUri());
            blob.upload(this.inputStream, this.streamLength);
            fileUploadCompletionNotification = new FileUploadCompletionNotification(sasUriResponse.getCorrelationId(), Boolean.valueOf(true), Integer.valueOf(0), "Succeed to upload to storage.");
            try {
                this.sendNotification(fileUploadCompletionNotification);
            }
            catch (IOException e) {
                log.error("Failed to send file upload status", (Throwable)e);
            }
            break block14;
            catch (StorageException | IOException | IllegalArgumentException | URISyntaxException e) {
                try {
                    log.error("File upload failed to upload the stream to the blob", e);
                    fileUploadCompletionNotification = new FileUploadCompletionNotification(sasUriResponse.getCorrelationId(), Boolean.valueOf(false), Integer.valueOf(-1), "Failed to upload to storage.");
                }
                catch (Throwable throwable) {
                    try {
                        this.sendNotification(fileUploadCompletionNotification);
                    }
                    catch (IOException e2) {
                        log.error("Failed to send file upload status", (Throwable)e2);
                    }
                    throw throwable;
                }
                try {
                    this.sendNotification(fileUploadCompletionNotification);
                }
                catch (IOException e3) {
                    log.error("Failed to send file upload status", (Throwable)e3);
                }
            }
        }
        if (fileUploadCompletionNotification.getSuccess().booleanValue()) {
            this.userCallback.execute(IotHubStatusCode.OK, this.userCallbackContext);
        } else {
            this.userCallback.execute(IotHubStatusCode.ERROR, this.userCallbackContext);
        }
    }

    public FileUploadSasUriResponse getFileUploadSasUri(FileUploadSasUriRequest request) throws IOException {
        IotHubTransportMessage message = new IotHubTransportMessage(request.toJson());
        message.setIotHubMethod(IotHubMethod.POST);
        this.httpsTransportManager.open();
        ResponseMessage responseMessage = this.httpsTransportManager.getFileUploadSasUri(message);
        this.httpsTransportManager.close();
        if (responseMessage.getBytes() == null || responseMessage.getBytes().length == 0) {
            throw new IOException("Sas URI response message had no payload");
        }
        return new FileUploadSasUriResponse(new String(responseMessage.getBytes(), DEFAULT_IOTHUB_MESSAGE_CHARSET));
    }

    public IotHubStatusCode sendNotification(FileUploadCompletionNotification fileUploadStatusParser) throws IOException {
        IotHubTransportMessage message = new IotHubTransportMessage(fileUploadStatusParser.toJson());
        message.setIotHubMethod(IotHubMethod.POST);
        this.httpsTransportManager.open();
        ResponseMessage responseMessage = this.httpsTransportManager.sendFileUploadNotification(message);
        this.httpsTransportManager.close();
        return responseMessage.getStatus();
    }

    public void close() {
        this.httpsTransportManager.close();
    }
}

