/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.hsm;

import com.microsoft.azure.sdk.iot.device.transport.https.HttpsRequest;
import com.microsoft.azure.sdk.iot.device.transport.https.HttpsResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HttpsRequestResponseSerializer {
    private static final String SP = " ";
    private static final String CR = "\r";
    private static final String LF = "\n";
    private static final String ProtocolVersionSeparator = "/";
    private static final String Protocol = "HTTP";
    private static final String HeaderSeparator = ":";
    private static final String VERSION = "1.1";
    private static final long MAXIMUM_HEADER_COUNT = 500L;

    public static byte[] serializeRequest(HttpsRequest httpsRequest, String path, String queryString, String host) throws IllegalArgumentException {
        if (httpsRequest == null) {
            throw new IllegalArgumentException("The httpsRequest cannot be null");
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("path cannot be null or empty");
        }
        if (host == null || host.isEmpty()) {
            throw new IllegalArgumentException("host cannot be null or empty");
        }
        httpsRequest.setHeaderField("Connection", "close");
        String updatedPath = HttpsRequestResponseSerializer.preProcessRequestPath(path);
        StringBuilder builder = new StringBuilder();
        builder.append(httpsRequest.getHttpMethod());
        builder.append(SP);
        builder.append(updatedPath);
        if (queryString != null && !queryString.isEmpty()) {
            builder.append("?" + queryString);
        }
        builder.append(SP);
        builder.append("HTTP/");
        builder.append(VERSION);
        builder.append(CR);
        builder.append(LF);
        builder.append("Host: " + host + "\r\n");
        if (httpsRequest.getRequestHeaders() != null && !httpsRequest.getRequestHeaders().isEmpty()) {
            builder.append(httpsRequest.getRequestHeaders());
        }
        if (httpsRequest.getBody() != null && httpsRequest.getBody().length != 0) {
            builder.append("Content-Length: " + httpsRequest.getBody().length + "\r\n");
        }
        builder.append(CR);
        builder.append(LF);
        return builder.toString().getBytes(StandardCharsets.US_ASCII);
    }

    public static HttpsResponse deserializeResponse(BufferedReader bufferedReader) throws IOException {
        int statusCode;
        if (bufferedReader == null) {
            throw new IllegalArgumentException("buffered reader cannot be null");
        }
        String statusLine = bufferedReader.readLine();
        if (statusLine == null || statusLine.isEmpty()) {
            throw new IOException("Response is empty.");
        }
        String[] statusLineParts = statusLine.split(SP);
        if (statusLineParts.length != 3) {
            throw new IOException("Status line is not valid.");
        }
        String[] httpVersion = statusLineParts[0].split(ProtocolVersionSeparator);
        if (httpVersion.length != 2) {
            throw new IOException("Version is not valid " + statusLineParts[0] + ".");
        }
        String version = httpVersion[1];
        try {
            String statusCodeString = statusLineParts[1];
            statusCode = Integer.valueOf(statusCodeString);
        }
        catch (NumberFormatException e) {
            throw new IOException("StatusCode is not valid " + statusLineParts[1] + ".");
        }
        Map<String, List<String>> headerFields = HttpsRequestResponseSerializer.readHeaderFields(bufferedReader);
        byte[] body = HttpsRequestResponseSerializer.readBody(bufferedReader);
        byte[] errorReason = statusLineParts[2].getBytes();
        bufferedReader.close();
        return new HttpsResponse(statusCode, body, headerFields, errorReason);
    }

    private static String preProcessRequestPath(String path) {
        String dnsSafePath = path.replace("[", "").replace("]", "");
        return dnsSafePath;
    }

    private static Map<String, List<String>> readHeaderFields(BufferedReader bufferedReader) throws IOException {
        String header;
        HashMap<String, List<String>> headerFields = new HashMap<String, List<String>>();
        ArrayList<String> headers = new ArrayList<String>();
        String line = bufferedReader.readLine();
        while (line != null && !line.isEmpty()) {
            headers.add(line);
            line = bufferedReader.readLine();
            if ((long)headers.size() <= 500L) continue;
            throw new IOException("HSM provided too many http headers");
        }
        Iterator iterator = headers.iterator();
        while (iterator.hasNext() && (header = (String)iterator.next()) != null && !header.isEmpty()) {
            int headerSeparatorPosition = header.indexOf(HeaderSeparator);
            if (headerSeparatorPosition <= 0) {
                throw new IOException("Header is invalid " + header + ".");
            }
            String headerName = header.substring(0, headerSeparatorPosition);
            String headerValue = header.substring(headerSeparatorPosition + 1);
            ArrayList<String> headerValues = new ArrayList<String>();
            headerValues.add(headerValue);
            headerFields.put(headerName, headerValues);
        }
        return headerFields;
    }

    private static byte[] readBody(BufferedReader bufferedReader) throws IOException {
        String bodyString = "";
        String next = bufferedReader.readLine();
        while (next != null && !next.isEmpty()) {
            bodyString = bodyString + next;
            next = bufferedReader.readLine();
        }
        return bodyString.getBytes();
    }
}

