/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.transport.IotHubTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IotHubSendTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(IotHubSendTask.class);
    private static final String THREAD_NAME = "azure-iot-sdk-IotHubSendTask";
    private final IotHubTransport transport;
    private final Object sendThreadLock;

    public IotHubSendTask(IotHubTransport transport) {
        if (transport == null) {
            throw new IllegalArgumentException("Parameter 'transport' must not be null");
        }
        this.transport = transport;
        this.sendThreadLock = this.transport.getSendThreadLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Thread.currentThread().setName(THREAD_NAME);
        try {
            Object object = this.sendThreadLock;
            synchronized (object) {
                if (!(this.transport.hasMessagesToSend() || this.transport.hasCallbacksToExecute() || this.transport.isClosed())) {
                    this.sendThreadLock.wait();
                }
            }
            this.transport.sendMessages();
            this.transport.invokeCallbacks();
        }
        catch (Throwable e) {
            log.warn("Send task encountered exception while sending messages", e);
        }
    }
}

