/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import com.microsoft.azure.sdk.iot.device.IotHubEventCallback;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;

public final class IotHubTransportPacket {
    private Message message;
    private IotHubEventCallback eventCallback;
    private Object callbackContext;
    private IotHubStatusCode status;
    private final long startTimeMillis;
    private int currentRetryAttempt;

    public IotHubTransportPacket(Message message, IotHubEventCallback eventCallback, Object callbackContext, IotHubStatusCode status, long startTimeMillis) throws IllegalArgumentException {
        if (startTimeMillis < 1L) {
            throw new IllegalArgumentException("start time cannot be 0 or negative");
        }
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null");
        }
        this.message = message;
        this.eventCallback = eventCallback;
        this.callbackContext = callbackContext;
        this.status = status;
        this.startTimeMillis = startTimeMillis;
    }

    public Message getMessage() {
        return this.message;
    }

    public IotHubEventCallback getCallback() {
        return this.eventCallback;
    }

    public Object getContext() {
        return this.callbackContext;
    }

    public IotHubStatusCode getStatus() {
        return this.status;
    }

    public void setStatus(IotHubStatusCode status) {
        this.status = status;
    }

    public long getStartTimeMillis() {
        return this.startTimeMillis;
    }

    public int getCurrentRetryAttempt() {
        return this.currentRetryAttempt;
    }

    public void incrementRetryAttempt() {
        ++this.currentRetryAttempt;
    }
}

