/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxiedSSLSocket
extends SSLSocket {
    private static final Logger log = LoggerFactory.getLogger(ProxiedSSLSocket.class);
    private final SSLSocketFactory socketFactory;
    private final Socket proxySocket;
    private SSLSocket sslSocket;
    private String proxyUsername;
    private char[] proxyPassword;
    private static final String HTTP = "HTTP/";
    private static final String HTTP_VERSION_1_1 = "HTTP/1.1";

    protected ProxiedSSLSocket(SSLSocketFactory socketFactory, Socket proxySocket, String proxyUsername, char[] proxyPassword) {
        this.socketFactory = socketFactory;
        this.proxySocket = proxySocket;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
    }

    @Override
    public void connect(SocketAddress socketAddress) throws IOException {
        this.connect(socketAddress, 0);
    }

    @Override
    public void connect(SocketAddress socketAddress, int timeout) throws IOException {
        log.debug("Sending tunnel handshake to HTTP proxy");
        this.doTunnelHandshake(this.proxySocket, ((InetSocketAddress)socketAddress).getHostName(), ((InetSocketAddress)socketAddress).getPort());
        log.debug("Handshake to HTTP proxy succeeded");
        this.sslSocket = (SSLSocket)this.socketFactory.createSocket(this.proxySocket, ((InetSocketAddress)socketAddress).getHostName(), ((InetSocketAddress)socketAddress).getPort(), true);
    }

    @Override
    public void close() throws IOException {
        this.proxySocket.close();
        this.sslSocket.close();
    }

    private void doTunnelHandshake(Socket tunnel, String host, int port) throws IOException {
        int connectResponseStatusCode;
        String proxyConnectMessage;
        Charset byteEncoding = StandardCharsets.UTF_8;
        OutputStream out = tunnel.getOutputStream();
        String hostWithPort = host + ":" + port;
        if (this.proxyUsername != null && this.proxyPassword != null) {
            String base64EncodedCredentials = new String(Base64.encodeBase64((byte[])String.format("%s:%s", this.proxyUsername, new String(this.proxyPassword)).getBytes(byteEncoding)));
            proxyConnectMessage = String.format("CONNECT %s %s\r\nHost: %s\r\nProxy-Authorization: Basic %s\r\n\r\n", hostWithPort, HTTP_VERSION_1_1, hostWithPort, base64EncodedCredentials);
        } else {
            proxyConnectMessage = String.format("CONNECT %s %s\r\nHost: %s\r\n\r\n", hostWithPort, HTTP_VERSION_1_1, hostWithPort);
        }
        byte[] proxyConnectBytes = proxyConnectMessage.getBytes(byteEncoding);
        out.write(proxyConnectBytes);
        out.flush();
        HttpConnectResponseReader in = new HttpConnectResponseReader(tunnel.getInputStream(), byteEncoding);
        String connectResponse = in.readHttpConnectResponse();
        String[] connectResponseLines = connectResponse.split("\r\n");
        int connectResponseStart = 0;
        while (connectResponseLines[connectResponseStart].isEmpty()) {
            ++connectResponseStart;
        }
        String firstLine = connectResponseLines[connectResponseStart];
        if (!firstLine.startsWith(HTTP)) {
            tunnel.close();
            throw new IOException(String.format("Unable to tunnel through %s:%d.  Expected first response line to start with %s, but proxy returns \"%s\"", host, port, HTTP, firstLine));
        }
        String[] replyStrParts = firstLine.split(" ");
        if (replyStrParts.length < 2) {
            tunnel.close();
            throw new IOException(String.format("Unable to tunnel through %s:%d. Expected proxy response to CONNECT to contain a space between http version and status code, but was %s", host, port, firstLine));
        }
        try {
            connectResponseStatusCode = Integer.parseInt(replyStrParts[1]);
        }
        catch (NumberFormatException e) {
            tunnel.close();
            throw new IOException(String.format("Unable to tunnel through %s:%d. Expected proxy response to CONNECT to contain a status code but status code could not be parsed. Response was %s", host, port, firstLine));
        }
        if (connectResponseStatusCode <= 199 || connectResponseStatusCode >= 300) {
            tunnel.close();
            throw new IOException(String.format("Unable to tunnel through %s:%d. Expected proxy response to CONNECT to return status code 2XX but status code was %d", host, port, connectResponseStatusCode));
        }
        log.trace("HTTP proxy responded to connect request with status {}, so the proxy connect was successful", (Object)connectResponseStatusCode);
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocket.getSupportedCipherSuites();
    }

    @Override
    public String[] getEnabledCipherSuites() {
        return this.sslSocket.getEnabledCipherSuites();
    }

    @Override
    public void setEnabledCipherSuites(String[] arg0) {
        this.sslSocket.setEnabledCipherSuites(arg0);
    }

    @Override
    public String[] getSupportedProtocols() {
        return this.sslSocket.getSupportedProtocols();
    }

    @Override
    public String[] getEnabledProtocols() {
        return this.sslSocket.getEnabledProtocols();
    }

    @Override
    public void setEnabledProtocols(String[] arg0) {
        this.sslSocket.setEnabledProtocols(arg0);
    }

    @Override
    public SSLSession getSession() {
        return this.sslSocket.getSession();
    }

    @Override
    public SSLSession getHandshakeSession() {
        return this.sslSocket.getHandshakeSession();
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener arg0) {
        this.sslSocket.addHandshakeCompletedListener(arg0);
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener arg0) {
        this.sslSocket.removeHandshakeCompletedListener(arg0);
    }

    @Override
    public void startHandshake() throws IOException {
        this.sslSocket.startHandshake();
    }

    @Override
    public void setUseClientMode(boolean arg0) {
        this.sslSocket.setUseClientMode(arg0);
    }

    @Override
    public boolean getUseClientMode() {
        return this.sslSocket.getUseClientMode();
    }

    @Override
    public void setNeedClientAuth(boolean arg0) {
        this.sslSocket.setNeedClientAuth(arg0);
    }

    @Override
    public boolean getNeedClientAuth() {
        return this.sslSocket.getNeedClientAuth();
    }

    @Override
    public void setWantClientAuth(boolean arg0) {
        this.sslSocket.setWantClientAuth(arg0);
    }

    @Override
    public boolean getWantClientAuth() {
        return this.sslSocket.getWantClientAuth();
    }

    @Override
    public void setEnableSessionCreation(boolean arg0) {
        this.sslSocket.setEnableSessionCreation(arg0);
    }

    @Override
    public boolean getEnableSessionCreation() {
        return this.sslSocket.getEnableSessionCreation();
    }

    @Override
    public SSLParameters getSSLParameters() {
        return this.sslSocket.getSSLParameters();
    }

    @Override
    public void setSSLParameters(SSLParameters arg0) {
        this.sslSocket.setSSLParameters(arg0);
    }

    @Override
    public String getApplicationProtocol() {
        return this.sslSocket.getApplicationProtocol();
    }

    @Override
    public String getHandshakeApplicationProtocol() {
        return this.sslSocket.getHandshakeApplicationProtocol();
    }

    @Override
    public void setHandshakeApplicationProtocolSelector(BiFunction<SSLSocket, List<String>, String> arg0) {
        this.sslSocket.setHandshakeApplicationProtocolSelector(arg0);
    }

    @Override
    public BiFunction<SSLSocket, List<String>, String> getHandshakeApplicationProtocolSelector() {
        return this.sslSocket.getHandshakeApplicationProtocolSelector();
    }

    @Override
    public void bind(SocketAddress arg0) throws IOException {
        this.sslSocket.bind(arg0);
    }

    @Override
    public InetAddress getInetAddress() {
        return this.sslSocket.getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        return this.sslSocket.getLocalAddress();
    }

    @Override
    public int getPort() {
        return this.sslSocket.getPort();
    }

    @Override
    public int getLocalPort() {
        return this.sslSocket.getLocalPort();
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.sslSocket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.sslSocket.getLocalSocketAddress();
    }

    @Override
    public SocketChannel getChannel() {
        return this.sslSocket.getChannel();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.sslSocket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.sslSocket.getOutputStream();
    }

    @Override
    public void setTcpNoDelay(boolean arg0) throws SocketException {
        this.sslSocket.setTcpNoDelay(arg0);
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.sslSocket.getTcpNoDelay();
    }

    @Override
    public void setSoLinger(boolean arg0, int arg1) throws SocketException {
        this.sslSocket.setSoLinger(arg0, arg1);
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.sslSocket.getSoLinger();
    }

    @Override
    public void sendUrgentData(int arg0) throws IOException {
        this.sslSocket.sendUrgentData(arg0);
    }

    @Override
    public void setOOBInline(boolean arg0) throws SocketException {
        this.sslSocket.setOOBInline(arg0);
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.sslSocket.getOOBInline();
    }

    @Override
    public void setSoTimeout(int arg0) throws SocketException {
        this.sslSocket.setSoTimeout(arg0);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.sslSocket.getSoTimeout();
    }

    @Override
    public void setSendBufferSize(int arg0) throws SocketException {
        this.sslSocket.setSendBufferSize(arg0);
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.sslSocket.getSendBufferSize();
    }

    @Override
    public void setReceiveBufferSize(int arg0) throws SocketException {
        this.sslSocket.setReceiveBufferSize(arg0);
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.sslSocket.getReceiveBufferSize();
    }

    @Override
    public void setKeepAlive(boolean arg0) throws SocketException {
        this.sslSocket.setKeepAlive(arg0);
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return this.sslSocket.getKeepAlive();
    }

    @Override
    public void setTrafficClass(int arg0) throws SocketException {
        this.sslSocket.setTrafficClass(arg0);
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.sslSocket.getTrafficClass();
    }

    @Override
    public void setReuseAddress(boolean arg0) throws SocketException {
        this.sslSocket.setReuseAddress(arg0);
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.sslSocket.getReuseAddress();
    }

    @Override
    public void shutdownInput() throws IOException {
        this.sslSocket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.sslSocket.shutdownOutput();
    }

    @Override
    public boolean isConnected() {
        return this.sslSocket.isConnected();
    }

    @Override
    public boolean isBound() {
        return this.sslSocket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.sslSocket.isClosed();
    }

    @Override
    public boolean isInputShutdown() {
        return this.sslSocket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.sslSocket.isOutputShutdown();
    }

    @Override
    public void setPerformancePreferences(int arg0, int arg1, int arg2) {
        this.sslSocket.setPerformancePreferences(arg0, arg1, arg2);
    }

    class HttpConnectResponseReader {
        private boolean alreadyRead = false;
        @NonNull
        private InputStream inputStream;
        @NonNull
        private Charset byteEncoding;

        String readHttpConnectResponse() throws IOException {
            if (this.alreadyRead) {
                throw new IOException("Http connect response has already been read");
            }
            ByteArrayOutputStream httpLineOutputStream = new ByteArrayOutputStream();
            LinkedList<Integer> mostRecentFourCharacters = new LinkedList<Integer>();
            while (!this.isCRLF(mostRecentFourCharacters)) {
                int i = this.inputStream.read();
                if (i == -1) {
                    this.inputStream.close();
                    throw new IOException("Unexpected EOF from proxy");
                }
                httpLineOutputStream.write(i);
                if (mostRecentFourCharacters.size() == 4) {
                    mostRecentFourCharacters.poll();
                }
                mostRecentFourCharacters.offer(i);
            }
            String httpHeaderLine = new String(httpLineOutputStream.toByteArray(), this.byteEncoding);
            httpLineOutputStream.close();
            this.alreadyRead = true;
            return httpHeaderLine;
        }

        boolean isCRLF(List<Integer> list) {
            if (list.size() < 4) {
                return false;
            }
            return list.get(0) == 13 && list.get(1) == 10 && list.get(2) == 13 && list.get(3) == 10;
        }

        public HttpConnectResponseReader(@NonNull InputStream inputStream, Charset byteEncoding) {
            if (inputStream == null) {
                throw new NullPointerException("inputStream is marked non-null but is null");
            }
            if (byteEncoding == null) {
                throw new NullPointerException("byteEncoding is marked non-null but is null");
            }
            this.inputStream = inputStream;
            this.byteEncoding = byteEncoding;
        }
    }

    private static interface ProxiedSSLSocketNonDelegatedFunctions {
        public void connect(SocketAddress var1, int var2) throws IOException;

        public void connect(SocketAddress var1) throws IOException;

        public void close() throws IOException;
    }
}

