/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.sdk.iot.device.transport.mqtt;

import com.microsoft.azure.sdk.iot.device.DeviceClientConfig;
import com.microsoft.azure.sdk.iot.device.IotHubMessageResult;
import com.microsoft.azure.sdk.iot.device.IotHubStatusCode;
import com.microsoft.azure.sdk.iot.device.Message;
import com.microsoft.azure.sdk.iot.device.MessageType;
import com.microsoft.azure.sdk.iot.device.exceptions.TransportException;
import com.microsoft.azure.sdk.iot.device.transport.IotHubConnectionStatus;
import com.microsoft.azure.sdk.iot.device.transport.IotHubListener;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportConnection;
import com.microsoft.azure.sdk.iot.device.transport.IotHubTransportMessage;
import com.microsoft.azure.sdk.iot.device.transport.TransportUtils;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttConnection;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttDeviceMethod;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttDeviceTwin;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttMessageListener;
import com.microsoft.azure.sdk.iot.device.transport.mqtt.MqttMessaging;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MqttIotHubConnection
implements IotHubTransportConnection,
MqttMessageListener {
    private static final Logger log = LoggerFactory.getLogger(MqttIotHubConnection.class);
    private final Object MQTT_CONNECTION_LOCK = new Object();
    private final DeviceClientConfig config;
    private IotHubConnectionStatus state = IotHubConnectionStatus.DISCONNECTED;
    private String iotHubUserName;
    private String iotHubUserPassword;
    private MqttConnection mqttConnection;
    private static final String WS_SSL_PREFIX = "wss://";
    private static final String WEBSOCKET_RAW_PATH = "/$iothub/websocket";
    private static final String NO_CLIENT_CERT_QUERY_STRING = "?iothub-no-client-cert=true";
    private static final String SSL_PREFIX = "ssl://";
    private static final String SSL_PORT_SUFFIX = ":8883";
    private static final String ModelIdParam = "model-id";
    private String connectionId;
    private String webSocketQueryString;
    private IotHubListener listener;
    private MqttMessaging deviceMessaging;
    private MqttDeviceTwin deviceTwin;
    private MqttDeviceMethod deviceMethod;
    private Map<IotHubTransportMessage, Integer> receivedMessagesToAcknowledge = new ConcurrentHashMap<IotHubTransportMessage, Integer>();
    private Map<Integer, Message> unacknowledgedSentMessages = new ConcurrentHashMap<Integer, Message>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MqttIotHubConnection(DeviceClientConfig config) throws IllegalArgumentException {
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (config == null) {
                throw new IllegalArgumentException("The DeviceClientConfig cannot be null.");
            }
            if (config.getIotHubHostname() == null || config.getIotHubHostname().length() == 0) {
                throw new IllegalArgumentException("hostName cannot be null or empty.");
            }
            if (config.getDeviceId() == null || config.getDeviceId().length() == 0) {
                throw new IllegalArgumentException("deviceID cannot be null or empty.");
            }
            if (config.getIotHubName() == null || config.getIotHubName().length() == 0) {
                throw new IllegalArgumentException("hubName cannot be null or empty.");
            }
            this.config = config;
            this.deviceMessaging = null;
            this.deviceMethod = null;
            this.deviceTwin = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open(Queue<DeviceClientConfig> deviceClientConfigs, ScheduledExecutorService scheduledExecutorService) throws TransportException {
        this.connectionId = UUID.randomUUID().toString();
        if (deviceClientConfigs.size() > 1) {
            throw new UnsupportedOperationException("Mqtt does not support Multiplexing");
        }
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (this.state == IotHubConnectionStatus.CONNECTED) {
                return;
            }
            log.debug("Opening MQTT connection...");
            try {
                String modelId;
                SSLContext sslContext = this.config.getAuthenticationProvider().getSSLContext();
                if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.SAS_TOKEN) {
                    log.trace("MQTT connection will use sas token based auth");
                    this.iotHubUserPassword = this.config.getSasTokenAuthentication().getRenewedSasToken(false, false);
                    this.webSocketQueryString = NO_CLIENT_CERT_QUERY_STRING;
                } else if (this.config.getAuthenticationType() == DeviceClientConfig.AuthType.X509_CERTIFICATE) {
                    log.trace("MQTT connection will use X509 certificate based auth");
                    this.iotHubUserPassword = null;
                }
                String userAgentString = this.config.getProductInfo().getUserAgentString();
                String clientUserAgentIdentifier = "DeviceClientType=" + URLEncoder.encode(userAgentString, "UTF-8").replaceAll("\\+", "%20");
                String clientId = this.config.getDeviceId();
                String moduleId = this.config.getModuleId();
                if (moduleId != null && !moduleId.isEmpty()) {
                    clientId = clientId + "/" + moduleId;
                }
                String serviceParams = (modelId = this.config.getModelId()) == null || modelId.isEmpty() ? TransportUtils.IOTHUB_API_VERSION : TransportUtils.IOTHUB_API_VERSION_PREVIEW + "&" + ModelIdParam + "=" + modelId;
                this.iotHubUserName = this.config.getIotHubHostname() + "/" + clientId + "/?api-version=" + serviceParams + "&" + clientUserAgentIdentifier;
                String host = this.config.getGatewayHostname();
                if (host == null || host.isEmpty()) {
                    host = this.config.getIotHubHostname();
                }
                if (this.config.isUseWebsocket()) {
                    String wsServerUri = this.webSocketQueryString == null ? WS_SSL_PREFIX + host + WEBSOCKET_RAW_PATH : WS_SSL_PREFIX + host + WEBSOCKET_RAW_PATH + this.webSocketQueryString;
                    this.mqttConnection = new MqttConnection(wsServerUri, clientId, this.iotHubUserName, this.iotHubUserPassword, sslContext, this.config.getProxySettings());
                } else {
                    String serverUri = SSL_PREFIX + host + SSL_PORT_SUFFIX;
                    this.mqttConnection = new MqttConnection(serverUri, clientId, this.iotHubUserName, this.iotHubUserPassword, sslContext, null);
                }
                this.deviceMessaging = new MqttMessaging(this.mqttConnection, this.config.getDeviceId(), this.listener, this, this.connectionId, this.config.getModuleId(), this.config.getGatewayHostname() != null && !this.config.getGatewayHostname().isEmpty(), this.unacknowledgedSentMessages);
                this.mqttConnection.setMqttCallback(this.deviceMessaging);
                this.deviceMethod = new MqttDeviceMethod(this.mqttConnection, this.connectionId, this.unacknowledgedSentMessages);
                this.deviceTwin = new MqttDeviceTwin(this.mqttConnection, this.connectionId, this.unacknowledgedSentMessages);
                this.deviceMessaging.start();
                this.state = IotHubConnectionStatus.CONNECTED;
                log.debug("MQTT connection opened successfully");
                this.listener.onConnectionEstablished(this.connectionId);
            }
            catch (IOException e) {
                log.error("Exception encountered while opening MQTT connection; closing connection", (Throwable)e);
                this.state = IotHubConnectionStatus.DISCONNECTED;
                if (this.deviceMethod != null) {
                    this.deviceMethod.stop();
                }
                if (this.deviceTwin != null) {
                    this.deviceTwin.stop();
                }
                if (this.deviceMessaging != null) {
                    this.deviceMessaging.stop();
                }
                throw new TransportException(e);
            }
        }
    }

    @Override
    public void close() throws TransportException {
        if (this.state == IotHubConnectionStatus.DISCONNECTED) {
            return;
        }
        log.debug("Closing MQTT connection");
        try {
            if (this.deviceMethod != null) {
                this.deviceMethod.stop();
                this.deviceMethod = null;
            }
            if (this.deviceTwin != null) {
                this.deviceTwin.stop();
                this.deviceTwin = null;
            }
            if (this.deviceMessaging != null) {
                this.deviceMessaging.stop();
                this.deviceMessaging = null;
            }
            this.state = IotHubConnectionStatus.DISCONNECTED;
            log.debug("Successfully closed MQTT connection");
        }
        catch (TransportException e) {
            this.state = IotHubConnectionStatus.DISCONNECTED;
            log.error("Exception encountered while closing MQTT connection, connection state is unknown", (Throwable)e);
            throw e;
        }
    }

    private IotHubTransportMessage receiveMessage() throws TransportException {
        IotHubTransportMessage message = this.deviceMethod.receive();
        if (message != null) {
            log.trace("Received MQTT device method message ({})", (Object)message);
            return message;
        }
        message = this.deviceTwin.receive();
        if (message != null) {
            log.trace("Received MQTT device twin message ({})", (Object)message);
            return message;
        }
        message = this.deviceMessaging.receive();
        if (message != null) {
            log.trace("Received MQTT device messaging message ({})", (Object)message);
            return message;
        }
        return null;
    }

    @Override
    public void setListener(IotHubListener listener) throws IllegalArgumentException {
        if (listener == null) {
            throw new IllegalArgumentException("listener cannot be null");
        }
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IotHubStatusCode sendMessage(Message message) throws TransportException {
        Object object = this.MQTT_CONNECTION_LOCK;
        synchronized (object) {
            if (message == null || message.getBytes() == null || message.getMessageType() != MessageType.DEVICE_TWIN && message.getMessageType() != MessageType.DEVICE_METHODS && message.getBytes().length == 0) {
                return IotHubStatusCode.BAD_FORMAT;
            }
            if (this.state == IotHubConnectionStatus.DISCONNECTED) {
                throw new IllegalStateException("Cannot send event using a closed MQTT connection");
            }
            IotHubStatusCode result = IotHubStatusCode.OK_EMPTY;
            if (message.getMessageType() == MessageType.DEVICE_METHODS) {
                this.deviceMethod.start();
                log.trace("Sending MQTT device method message ({})", (Object)message);
                this.deviceMethod.send((IotHubTransportMessage)message);
            } else if (message.getMessageType() == MessageType.DEVICE_TWIN) {
                this.deviceTwin.start();
                log.trace("Sending MQTT device twin message ({})", (Object)message);
                this.deviceTwin.send((IotHubTransportMessage)message);
            } else {
                log.trace("Sending MQTT device telemetry message ({})", (Object)message);
                this.deviceMessaging.send(message);
            }
            return result;
        }
    }

    @Override
    public boolean sendMessageResult(IotHubTransportMessage message, IotHubMessageResult result) throws TransportException {
        boolean ackSent;
        if (message == null || result == null) {
            throw new TransportException(new IllegalArgumentException("message and result must be non-null"));
        }
        log.trace("Checking if MQTT layer can acknowledge the received message ({})", (Object)message);
        if (!this.receivedMessagesToAcknowledge.containsKey(message)) {
            TransportException e = new TransportException(new IllegalArgumentException("Provided message cannot be acknowledged because it was already acknowledged or was never received from service"));
            log.error("Mqtt layer could not acknowledge received message because it has no mapping to an outstanding mqtt message id ({})", (Object)message, (Object)e);
            throw e;
        }
        int messageId = this.receivedMessagesToAcknowledge.get(message);
        log.trace("Sending MQTT ACK for a received message ({})", (Object)message);
        if (message.getMessageType() == MessageType.DEVICE_METHODS) {
            this.deviceMethod.start();
            ackSent = this.deviceMethod.sendMessageAcknowledgement(messageId);
        } else if (message.getMessageType() == MessageType.DEVICE_TWIN) {
            this.deviceTwin.start();
            ackSent = this.deviceTwin.sendMessageAcknowledgement(messageId);
        } else {
            ackSent = this.deviceMessaging.sendMessageAcknowledgement(messageId);
        }
        if (ackSent) {
            log.trace("MQTT ACK was sent for a received message so it has been removed from the messages to acknowledge list ({})", (Object)message);
            this.receivedMessagesToAcknowledge.remove(message);
        }
        return ackSent;
    }

    @Override
    public String getConnectionId() {
        return this.connectionId;
    }

    @Override
    public void onMessageArrived(int messageId) {
        IotHubTransportMessage transportMessage = null;
        try {
            transportMessage = this.receiveMessage();
        }
        catch (TransportException e) {
            this.listener.onMessageReceived(null, new TransportException("Failed to receive message from service", e));
            log.error("Encountered exception while receiving message over MQTT", (Throwable)e);
        }
        if (transportMessage == null) {
            this.listener.onMessageReceived(null, new TransportException("Message sent from service could not be parsed"));
            log.warn("Received message that could not be parsed. That message has been ignored.");
        } else {
            log.trace("MQTT received message so it has been added to the messages to acknowledge list ({})", (Object)transportMessage);
            this.receivedMessagesToAcknowledge.put(transportMessage, messageId);
            switch (transportMessage.getMessageType()) {
                case DEVICE_TWIN: {
                    transportMessage.setMessageCallback(this.config.getDeviceTwinMessageCallback());
                    transportMessage.setMessageCallbackContext(this.config.getDeviceTwinMessageContext());
                    break;
                }
                case DEVICE_METHODS: {
                    transportMessage.setMessageCallback(this.config.getDeviceMethodsMessageCallback());
                    transportMessage.setMessageCallbackContext(this.config.getDeviceMethodsMessageContext());
                    break;
                }
                case DEVICE_TELEMETRY: {
                    transportMessage.setMessageCallback(this.config.getDeviceTelemetryMessageCallback(transportMessage.getInputName()));
                    transportMessage.setMessageCallbackContext(this.config.getDeviceTelemetryMessageContext(transportMessage.getInputName()));
                    break;
                }
            }
            this.listener.onMessageReceived(transportMessage, null);
        }
    }
}

