/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.ConnectionMessage;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class ConnectionMessageEventArgs {
    private ConnectionMessage message;

    ConnectionMessageEventArgs(long eventArgs) {
        Contracts.throwIfNull(eventArgs, "eventArgs is null");
        SafeHandle eventHandle = null;
        eventHandle = new SafeHandle(eventArgs, SafeHandleType.ConnectionMessageEvent);
        Contracts.throwIfNull(eventHandle, "eventHandle");
        IntRef messageHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getConnectionMessage(eventHandle, messageHandle));
        this.message = new ConnectionMessage(messageHandle.getValue());
        eventHandle.close();
        eventHandle = null;
    }

    public ConnectionMessage getMessage() {
        return this.message;
    }

    public String toString() {
        return "Message: " + this.getMessage().toString();
    }

    private final native long getConnectionMessage(SafeHandle var1, IntRef var2);
}

