/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.OutputFormat;
import com.microsoft.cognitiveservices.speech.ProfanityOption;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionModel;
import com.microsoft.cognitiveservices.speech.SpeechSynthesisOutputFormat;
import com.microsoft.cognitiveservices.speech.SpeechTranslationModel;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.TelemetryManager;
import java.util.ArrayList;
import java.util.List;

public final class EmbeddedSpeechConfig
implements AutoCloseable {
    SpeechConfig config = null;
    private boolean disposed = false;

    EmbeddedSpeechConfig(long handleValue) {
        this.config = new SpeechConfig(handleValue);
        TelemetryManager.getSingleton();
    }

    public static final EmbeddedSpeechConfig fromPath(String path) {
        Contracts.throwIfNullOrWhitespace(path, "path");
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(EmbeddedSpeechConfig.createEmbeddedSpeechConfig(configRef));
        EmbeddedSpeechConfig embeddedSpeechConfig = new EmbeddedSpeechConfig(configRef.getValue());
        Contracts.throwIfFail(EmbeddedSpeechConfig.embeddedSpeechConfigAddPath(embeddedSpeechConfig.config.getImpl(), path));
        return embeddedSpeechConfig;
    }

    public static final EmbeddedSpeechConfig fromPaths(List<String> paths) {
        if (paths == null || paths.size() == 0) {
            throw new IllegalArgumentException("paths cannot be null or empty");
        }
        IntRef configRef = new IntRef(0L);
        Contracts.throwIfFail(EmbeddedSpeechConfig.createEmbeddedSpeechConfig(configRef));
        EmbeddedSpeechConfig embeddedSpeechConfig = new EmbeddedSpeechConfig(configRef.getValue());
        for (String path : paths) {
            Contracts.throwIfFail(EmbeddedSpeechConfig.embeddedSpeechConfigAddPath(embeddedSpeechConfig.config.getImpl(), path));
        }
        return embeddedSpeechConfig;
    }

    public final List<SpeechRecognitionModel> getSpeechRecognitionModels() {
        IntRef numModelsRef = new IntRef(0L);
        Contracts.throwIfFail(this.getNumSpeechRecognitionModels(this.config.getImpl(), numModelsRef));
        int numModels = (int)numModelsRef.getValue();
        ArrayList<SpeechRecognitionModel> models = new ArrayList<SpeechRecognitionModel>();
        for (int i = 0; i < numModels; ++i) {
            IntRef modelRef = new IntRef(0L);
            Contracts.throwIfFail(this.getSpeechRecognitionModel(this.config.getImpl(), i, modelRef));
            models.add(new SpeechRecognitionModel(modelRef));
        }
        return models;
    }

    public final void setSpeechRecognitionModel(String name, String key) {
        Contracts.throwIfNullOrWhitespace(name, "name");
        this.config.setProperty(PropertyId.SpeechServiceConnection_RecoModelName, name);
        if (key != null && key.length() != 0) {
            this.config.setProperty(PropertyId.SpeechServiceConnection_RecoModelKey, key);
        }
    }

    public final String getSpeechRecognitionModelName() {
        return this.config.getProperty(PropertyId.SpeechServiceConnection_RecoModelName);
    }

    public final void setSpeechRecognitionOutputFormat(OutputFormat value) {
        this.config.setOutputFormat(value);
    }

    public final OutputFormat getSpeechRecognitionOutputFormat() {
        return this.config.getOutputFormat();
    }

    public final void setProfanity(ProfanityOption value) {
        this.config.setProfanity(value);
    }

    public final void setSpeechSynthesisVoice(String name, String key) {
        Contracts.throwIfNullOrWhitespace(name, "name");
        this.config.setProperty(PropertyId.SpeechServiceConnection_SynthOfflineVoice, name);
        if (key != null && key.length() != 0) {
            this.config.setProperty(PropertyId.SpeechServiceConnection_SynthModelKey, key);
        }
    }

    public final String getSpeechSynthesisVoiceName() {
        return this.config.getProperty(PropertyId.SpeechServiceConnection_SynthOfflineVoice);
    }

    public final void setSpeechSynthesisOutputFormat(SpeechSynthesisOutputFormat value) {
        this.config.setSpeechSynthesisOutputFormat(value);
    }

    public final String getSpeechSynthesisOutputFormat() {
        return this.config.getSpeechSynthesisOutputFormat();
    }

    public final List<SpeechTranslationModel> getSpeechTranslationModels() {
        IntRef numModelsRef = new IntRef(0L);
        Contracts.throwIfFail(this.getNumSpeechTranslationModels(this.config.getImpl(), numModelsRef));
        int numModels = (int)numModelsRef.getValue();
        ArrayList<SpeechTranslationModel> models = new ArrayList<SpeechTranslationModel>();
        for (int i = 0; i < numModels; ++i) {
            IntRef modelRef = new IntRef(0L);
            Contracts.throwIfFail(this.getSpeechTranslationModel(this.config.getImpl(), i, modelRef));
            models.add(new SpeechTranslationModel(modelRef));
        }
        return models;
    }

    public final void setSpeechTranslationModel(String name, String key) {
        Contracts.throwIfNullOrWhitespace(name, "name");
        this.config.setProperty(PropertyId.SpeechTranslation_ModelName, name);
        if (key != null && key.length() != 0) {
            this.config.setProperty(PropertyId.SpeechTranslation_ModelKey, key);
        }
    }

    public final String getSpeechTranslationModelName() {
        return this.config.getProperty(PropertyId.SpeechTranslation_ModelName);
    }

    public void setProperty(String name, String value) {
        this.config.setProperty(name, value);
    }

    public void setProperty(PropertyId id, String value) {
        this.config.setProperty(id, value);
    }

    public String getProperty(String name) {
        return this.config.getProperty(name);
    }

    public String getProperty(PropertyId id) {
        return this.config.getProperty(id);
    }

    @Override
    public final void close() {
        if (this.disposed) {
            return;
        }
        if (this.config != null) {
            this.config.close();
            this.config = null;
        }
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        Contracts.throwIfNull(this.config, "config");
        return this.config.getImpl();
    }

    private static final native long createEmbeddedSpeechConfig(IntRef var0);

    private static final native long embeddedSpeechConfigAddPath(SafeHandle var0, String var1);

    private final native long getNumSpeechRecognitionModels(SafeHandle var1, IntRef var2);

    private final native long getSpeechRecognitionModel(SafeHandle var1, int var2, IntRef var3);

    private final native long getNumSpeechTranslationModels(SafeHandle var1, IntRef var2);

    private final native long getSpeechTranslationModel(SafeHandle var1, int var2, IntRef var3);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

