/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public class Grammar
implements AutoCloseable {
    private SafeHandle grammarHandle = null;
    private boolean disposed = false;

    public static Grammar fromStorageId(String id) {
        IntRef grammarRef = new IntRef(0L);
        Contracts.throwIfFail(Grammar.fromStorageId(grammarRef, id));
        return new Grammar(grammarRef.getValue());
    }

    @Override
    public void close() {
        this.dispose(true);
    }

    public SafeHandle getImpl() {
        return this.grammarHandle;
    }

    private void dispose(boolean disposing) {
        if (this.disposed) {
            return;
        }
        if (disposing && this.grammarHandle != null) {
            this.grammarHandle.close();
            this.grammarHandle = null;
        }
        this.disposed = true;
    }

    Grammar(long grammarHandleValue) {
        Contracts.throwIfNull(grammarHandleValue, "grammarHandleValue");
        this.grammarHandle = new SafeHandle(grammarHandleValue, SafeHandleType.Grammar);
    }

    private static final native long fromStorageId(IntRef var0, String var1);
}

