/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public class PropertyCollection
implements AutoCloseable {
    private SafeHandle propertyHandle = null;

    public PropertyCollection(IntRef propHandle) {
        if (propHandle != null) {
            this.propertyHandle = new SafeHandle(propHandle.getValue(), SafeHandleType.PropertyCollection);
        }
    }

    public String getProperty(String name) {
        return this.getPropertyString(this.propertyHandle, -1, name, "");
    }

    public String getProperty(String name, String defaultValue) {
        Contracts.throwIfNull(this.propertyHandle, "collection");
        Contracts.throwIfNullOrWhitespace(name, "name");
        return this.getPropertyString(this.propertyHandle, -1, name, defaultValue);
    }

    public String getProperty(PropertyId id) {
        Contracts.throwIfNull(this.propertyHandle, "collection");
        return this.getPropertyString(this.propertyHandle, id.getValue(), null, "");
    }

    public void setProperty(String name, String value) {
        Contracts.throwIfNull(this.propertyHandle, "collection");
        Contracts.throwIfNullOrWhitespace(name, "name");
        Contracts.throwIfNull(value, "value");
        Contracts.throwIfFail(this.setPropertyString(this.propertyHandle, -1, name, value));
    }

    public void setProperty(PropertyId id, String value) {
        Contracts.throwIfNull(this.propertyHandle, "collection");
        Contracts.throwIfNull(value, "value");
        Contracts.throwIfFail(this.setPropertyString(this.propertyHandle, id.getValue(), null, value));
    }

    @Override
    public void close() {
        if (this.propertyHandle != null) {
            this.propertyHandle.close();
            this.propertyHandle = null;
        }
    }

    private final native long setPropertyString(SafeHandle var1, int var2, String var3, String var4);

    private final native String getPropertyString(SafeHandle var1, int var2, String var3, String var4);
}

