/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import java.math.BigInteger;

public class RecognitionEventArgs
extends SessionEventArgs {
    public BigInteger offset;

    public RecognitionEventArgs(long eventArgs) {
        super(eventArgs);
        this.storeEventData(false);
    }

    public RecognitionEventArgs(long eventArgs, boolean dispose) {
        super(eventArgs);
        this.storeEventData(dispose);
    }

    @Override
    public String toString() {
        return "SessionId: " + this.getSessionId() + " Offset: " + this.offset.toString() + ".";
    }

    private void storeEventData(boolean disposeNativeResources) {
        Contracts.throwIfNull(this.eventHandle, "eventHandle");
        IntRef errorHandle = new IntRef(0L);
        this.offset = this.getOffset(this.eventHandle, errorHandle);
        Contracts.throwIfFail(errorHandle.getValue());
        if (disposeNativeResources) {
            super.close();
        }
    }

    protected final native long getRecognitionResult(SafeHandle var1, IntRef var2);

    private final native BigInteger getOffset(SafeHandle var1, IntRef var2);
}

