/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.math.BigInteger;

public class RecognitionResult
implements AutoCloseable {
    private SafeHandle resultHandle = null;
    private PropertyCollection properties = null;
    private String resultId;
    private ResultReason reason;
    private String text;
    private BigInteger duration;
    private BigInteger offset;

    protected RecognitionResult(long result) {
        if (result != 0L) {
            this.resultHandle = new SafeHandle(result, SafeHandleType.RecognitionResult);
            StringRef stringVal = new StringRef("");
            Contracts.throwIfFail(this.getResultId(this.resultHandle, stringVal));
            this.resultId = stringVal.getValue();
            IntRef intVal = new IntRef(0L);
            Contracts.throwIfFail(this.getResultReason(this.resultHandle, intVal));
            this.reason = ResultReason.values()[(int)intVal.getValue()];
            Contracts.throwIfFail(this.getResultText(this.resultHandle, stringVal));
            this.text = stringVal.getValue();
            this.duration = this.getResultDuration(this.resultHandle, intVal);
            Contracts.throwIfFail(intVal.getValue());
            this.offset = this.getResultOffset(this.resultHandle, intVal);
            Contracts.throwIfFail(intVal.getValue());
            IntRef propertyHandle = new IntRef(0L);
            Contracts.throwIfFail(this.getPropertyBagFromResult(this.resultHandle, propertyHandle));
            this.properties = new PropertyCollection(propertyHandle);
        }
    }

    public String getResultId() {
        return this.resultId;
    }

    public ResultReason getReason() {
        return this.reason;
    }

    public String getText() {
        return this.text;
    }

    public BigInteger getDuration() {
        return this.duration;
    }

    public BigInteger getOffset() {
        return this.offset;
    }

    public PropertyCollection getProperties() {
        return this.properties;
    }

    @Override
    public void close() {
        if (this.resultHandle != null) {
            this.resultHandle.close();
            this.resultHandle = null;
        }
        if (this.properties != null) {
            this.properties.close();
            this.properties = null;
        }
    }

    public SafeHandle getImpl() {
        Contracts.throwIfNull(this.resultHandle, "result");
        return this.resultHandle;
    }

    private final native long getResultId(SafeHandle var1, StringRef var2);

    private final native long getResultReason(SafeHandle var1, IntRef var2);

    private final native long getResultText(SafeHandle var1, StringRef var2);

    private final native BigInteger getResultDuration(SafeHandle var1, IntRef var2);

    private final native BigInteger getResultOffset(SafeHandle var1, IntRef var2);

    private final native long getPropertyBagFromResult(SafeHandle var1, IntRef var2);
}

