/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class SourceLanguageConfig
implements AutoCloseable {
    private SafeHandle configHandle = null;
    private boolean disposed = false;

    public static SourceLanguageConfig fromLanguage(String language) {
        Contracts.throwIfIllegalLanguage(language, "invalid language value");
        IntRef langConfigRef = new IntRef(0L);
        Contracts.throwIfFail(SourceLanguageConfig.fromLanguage(langConfigRef, language));
        return new SourceLanguageConfig(langConfigRef.getValue());
    }

    public static SourceLanguageConfig fromLanguage(String language, String endpointId) {
        Contracts.throwIfIllegalLanguage(language, "invalid language value");
        Contracts.throwIfNullOrWhitespace(endpointId, "endpointId cannot be empty");
        IntRef langConfigRef = new IntRef(0L);
        Contracts.throwIfFail(SourceLanguageConfig.fromLanguageAndEndpointId(langConfigRef, language, endpointId));
        return new SourceLanguageConfig(langConfigRef.getValue());
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.configHandle != null) {
            this.configHandle.close();
            this.configHandle = null;
        }
        this.disposed = true;
    }

    public SafeHandle getImpl() {
        return this.configHandle;
    }

    private SourceLanguageConfig(long handleValue) {
        Contracts.throwIfNull(handleValue, "handleValue");
        this.configHandle = new SafeHandle(handleValue, SafeHandleType.SourceLanguageConfig);
    }

    private static final native long fromLanguage(IntRef var0, String var1);

    private static final native long fromLanguageAndEndpointId(IntRef var0, String var1, String var2);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

