/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class SpeechSynthesisBookmarkEventArgs {
    private String resultId;
    private long audioOffset;
    private String text;

    SpeechSynthesisBookmarkEventArgs(long eventArgs) {
        Contracts.throwIfNull(eventArgs, "eventArgs");
        SafeHandle eventHandle = new SafeHandle(eventArgs, SafeHandleType.SynthesisEvent);
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getResultId(eventHandle, stringRef));
        this.resultId = stringRef.getValue();
        IntRef audioOffsetRef = new IntRef(0L);
        Contracts.throwIfFail(this.getBookmarkEventValues(eventHandle, audioOffsetRef));
        this.audioOffset = audioOffsetRef.getValue();
        Contracts.throwIfFail(this.getTextFromHandle(eventHandle, stringRef));
        this.text = stringRef.getValue();
        eventHandle.close();
    }

    public String getResultId() {
        return this.resultId;
    }

    public long getAudioOffset() {
        return this.audioOffset;
    }

    public String getText() {
        return this.text;
    }

    private final native long getResultId(SafeHandle var1, StringRef var2);

    private final native long getBookmarkEventValues(SafeHandle var1, IntRef var2);

    private final native long getTextFromHandle(SafeHandle var1, StringRef var2);
}

