/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SpeechSynthesisResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public class SpeechSynthesisEventArgs
implements AutoCloseable {
    private SpeechSynthesisResult result;
    private SafeHandle eventHandle;

    SpeechSynthesisEventArgs(long eventArgs) {
        Contracts.throwIfNull(eventArgs, "eventArgs");
        this.eventHandle = new SafeHandle(eventArgs, SafeHandleType.SynthesisEvent);
        IntRef resultRef = new IntRef(0L);
        Contracts.throwIfFail(this.getSynthesisResult(this.eventHandle, resultRef));
        this.result = new SpeechSynthesisResult(resultRef);
    }

    public SpeechSynthesisResult getResult() {
        return this.result;
    }

    @Override
    public void close() {
        if (this.eventHandle != null) {
            this.eventHandle.close();
            this.eventHandle = null;
        }
        if (this.result != null) {
            this.result.close();
            this.result = null;
        }
    }

    private final native long getSynthesisResult(SafeHandle var1, IntRef var2);
}

