/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class SpeechSynthesisResult
implements AutoCloseable {
    private String resultId;
    private ResultReason reason;
    private long audioLength;
    private long audioDuration;
    private byte[] audioData;
    private PropertyCollection properties;
    private SafeHandle resultHandle = null;

    protected SpeechSynthesisResult(IntRef result) {
        Contracts.throwIfNull(result, "result");
        this.resultHandle = new SafeHandle(result.getValue(), SafeHandleType.SynthesisResult);
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getResultId(this.resultHandle, stringRef));
        this.resultId = stringRef.getValue();
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getResultReason(this.resultHandle, intRef));
        this.reason = ResultReason.values()[(int)intRef.getValue()];
        IntRef audioLengthRef = new IntRef(0L);
        IntRef audioDurationRef = new IntRef(0L);
        Contracts.throwIfFail(this.getAudioLength(this.resultHandle, audioLengthRef, audioDurationRef));
        this.audioLength = audioLengthRef.getValue();
        this.audioDuration = audioDurationRef.getValue() * 10000L;
        this.audioData = null;
        IntRef propertyRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromResult(this.resultHandle, propertyRef));
        this.properties = new PropertyCollection(propertyRef);
    }

    public String getResultId() {
        return this.resultId;
    }

    public ResultReason getReason() {
        return this.reason;
    }

    public long getAudioLength() {
        return this.audioLength;
    }

    public long getAudioDuration() {
        return this.audioDuration;
    }

    public byte[] getAudioData() {
        if (this.audioData == null) {
            IntRef hr = new IntRef(0L);
            this.audioData = this.getAudio(this.resultHandle, hr);
            Contracts.throwIfFail(hr.getValue());
        }
        return this.audioData;
    }

    public PropertyCollection getProperties() {
        return this.properties;
    }

    @Override
    public void close() {
        if (this.resultHandle != null) {
            this.resultHandle.close();
            this.resultHandle = null;
        }
        if (this.properties != null) {
            this.properties.close();
            this.properties = null;
        }
    }

    public SafeHandle getImpl() {
        return this.resultHandle;
    }

    private final native long getResultId(SafeHandle var1, StringRef var2);

    private final native long getResultReason(SafeHandle var1, IntRef var2);

    private final native long getPropertyBagFromResult(SafeHandle var1, IntRef var2);

    private final native long getAudioLength(SafeHandle var1, IntRef var2, IntRef var3);

    private final native byte[] getAudio(SafeHandle var1, IntRef var2);
}

