/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.SpeechSynthesisBoundaryType;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class SpeechSynthesisWordBoundaryEventArgs {
    private String resultId;
    private long audioOffset;
    private long duration;
    private long textOffset;
    private long wordLength;
    private String text;
    private SpeechSynthesisBoundaryType boundaryType;

    SpeechSynthesisWordBoundaryEventArgs(long eventArgs) {
        Contracts.throwIfNull(eventArgs, "eventArgs");
        SafeHandle eventHandle = new SafeHandle(eventArgs, SafeHandleType.SynthesisEvent);
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getResultId(eventHandle, stringRef));
        this.resultId = stringRef.getValue();
        IntRef audioOffsetRef = new IntRef(0L);
        IntRef durationRef = new IntRef(0L);
        IntRef textOffsetRef = new IntRef(0L);
        IntRef wordLengthRef = new IntRef(0L);
        IntRef boundaryTypeRef = new IntRef(0L);
        Contracts.throwIfFail(this.getWordBoundaryEventValues(eventHandle, audioOffsetRef, durationRef, textOffsetRef, wordLengthRef, boundaryTypeRef));
        this.audioOffset = audioOffsetRef.getValue();
        this.duration = durationRef.getValue();
        this.textOffset = textOffsetRef.getValue();
        if (this.textOffset > Integer.MAX_VALUE) {
            this.textOffset = -1L;
        }
        this.wordLength = wordLengthRef.getValue();
        this.boundaryType = SpeechSynthesisBoundaryType.values()[(int)boundaryTypeRef.getValue()];
        this.text = this.getTextFromHandle(eventHandle);
        eventHandle.close();
    }

    public String getResultId() {
        return this.resultId;
    }

    public long getAudioOffset() {
        return this.audioOffset;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getTextOffset() {
        return this.textOffset;
    }

    public long getWordLength() {
        return this.wordLength;
    }

    public String getText() {
        return this.text;
    }

    public SpeechSynthesisBoundaryType getBoundaryType() {
        return this.boundaryType;
    }

    private final native long getResultId(SafeHandle var1, StringRef var2);

    private final native long getWordBoundaryEventValues(SafeHandle var1, IntRef var2, IntRef var3, IntRef var4, IntRef var5, IntRef var6);

    private final native String getTextFromHandle(SafeHandle var1);
}

