/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.VoiceInfo;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SynthesisVoicesResult
implements AutoCloseable {
    private String resultId;
    private ResultReason reason;
    private String errorDetails;
    private List<VoiceInfo> voices;
    private PropertyCollection properties;
    private SafeHandle resultHandle = null;

    protected SynthesisVoicesResult(IntRef result) {
        Contracts.throwIfNull(result, "result");
        this.resultHandle = new SafeHandle(result.getValue(), SafeHandleType.SynthesisResult);
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getVoiceNumber(this.resultHandle, intRef));
        int voiceNumber = (int)intRef.getValue();
        ArrayList<VoiceInfo> voiceList = new ArrayList<VoiceInfo>();
        for (int i = 0; i < voiceNumber; ++i) {
            IntRef voiceInfoRef = new IntRef(0L);
            Contracts.throwIfFail(this.getVoiceInfo(this.resultHandle, i, voiceInfoRef));
            voiceList.add(new VoiceInfo(voiceInfoRef));
        }
        this.voices = Collections.unmodifiableList(voiceList);
        StringRef stringRef = new StringRef("");
        Contracts.throwIfFail(this.getResultId(this.resultHandle, stringRef));
        this.resultId = stringRef.getValue();
        Contracts.throwIfFail(this.getResultReason(this.resultHandle, intRef));
        this.reason = ResultReason.values()[(int)intRef.getValue()];
        IntRef propertyRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromResult(this.resultHandle, propertyRef));
        this.properties = new PropertyCollection(propertyRef);
        this.errorDetails = this.properties.getProperty(PropertyId.CancellationDetails_ReasonDetailedText);
    }

    public List<VoiceInfo> getVoices() {
        return this.voices;
    }

    public String getResultId() {
        return this.resultId;
    }

    public ResultReason getReason() {
        return this.reason;
    }

    public String getErrorDetails() {
        return this.errorDetails;
    }

    public PropertyCollection getProperties() {
        return this.properties;
    }

    @Override
    public void close() {
        if (this.resultHandle != null) {
            this.resultHandle.close();
            this.resultHandle = null;
        }
        if (this.properties != null) {
            this.properties.close();
            this.properties = null;
        }
        if (this.voices != null) {
            for (VoiceInfo v : this.voices) {
                v.close();
            }
            this.voices = null;
        }
    }

    public SafeHandle getImpl() {
        return this.resultHandle;
    }

    private final native long getResultId(SafeHandle var1, StringRef var2);

    private final native long getResultReason(SafeHandle var1, IntRef var2);

    private final native long getPropertyBagFromResult(SafeHandle var1, IntRef var2);

    private final native long getVoiceNumber(SafeHandle var1, IntRef var2);

    private final native long getVoiceInfo(SafeHandle var1, int var2, IntRef var3);
}

