/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.AudioOutputStream;
import com.microsoft.cognitiveservices.speech.audio.AudioProcessingOptions;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStreamCallback;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class AudioConfig
implements AutoCloseable {
    private SafeHandle audioConfigHandle = null;
    private AudioInputStream inputStreamKeepAlive = null;
    private AudioOutputStream outputStreamKeepAlive = null;
    private boolean closeKeepAliveOnClose = false;
    private PropertyCollection propertyHandle = null;

    public static AudioConfig fromDefaultMicrophoneInput() {
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromDefaultMicrophone(configHandle, null));
        return new AudioConfig(configHandle);
    }

    public static AudioConfig fromDefaultMicrophoneInput(AudioProcessingOptions audioProcessingOptions) {
        Contracts.throwIfNull(audioProcessingOptions, "audioProcessingOptions");
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromDefaultMicrophone(configHandle, audioProcessingOptions.getImpl()));
        return new AudioConfig(configHandle);
    }

    public static AudioConfig fromMicrophoneInput(String deviceName) {
        Contracts.throwIfNull(deviceName, "deviceName");
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromMicrophoneInput(configHandle, deviceName, null));
        return new AudioConfig(configHandle);
    }

    public static AudioConfig fromMicrophoneInput(String deviceName, AudioProcessingOptions audioProcessingOptions) {
        Contracts.throwIfNull(deviceName, "deviceName");
        Contracts.throwIfNull(audioProcessingOptions, "audioProcessingOptions");
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromMicrophoneInput(configHandle, deviceName, audioProcessingOptions.getImpl()));
        return new AudioConfig(configHandle);
    }

    public static AudioConfig fromWavFileInput(String fileName) {
        Contracts.throwIfNull(fileName, "fileName");
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromWavFileName(configHandle, fileName, null));
        return new AudioConfig(configHandle);
    }

    public static AudioConfig fromWavFileInput(String fileName, AudioProcessingOptions audioProcessingOptions) {
        Contracts.throwIfNull(fileName, "fileName");
        Contracts.throwIfNull(audioProcessingOptions, "audioProcessingOptions");
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromWavFileName(configHandle, fileName, audioProcessingOptions.getImpl()));
        return new AudioConfig(configHandle);
    }

    public static AudioConfig fromStreamInput(AudioInputStream audioStream) {
        Contracts.throwIfNull(audioStream, "audioStream");
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromStream(configHandle, audioStream.getImpl(), null));
        return new AudioConfig(configHandle, audioStream);
    }

    public static AudioConfig fromStreamInput(AudioInputStream audioStream, AudioProcessingOptions audioProcessingOptions) {
        Contracts.throwIfNull(audioStream, "audioStream");
        Contracts.throwIfNull(audioProcessingOptions, "audioProcessingOptions");
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromStream(configHandle, audioStream.getImpl(), audioProcessingOptions.getImpl()));
        return new AudioConfig(configHandle, audioStream);
    }

    public static AudioConfig fromStreamInput(PullAudioInputStreamCallback callback) {
        Contracts.throwIfNull(callback, "callback");
        PullAudioInputStream pullStream = PullAudioInputStream.create(callback);
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromStream(configHandle, pullStream.getImpl(), null));
        AudioConfig config = new AudioConfig(configHandle, pullStream);
        config.closeKeepAliveOnClose = true;
        return config;
    }

    public static AudioConfig fromStreamInput(PullAudioInputStreamCallback callback, AudioProcessingOptions audioProcessingOptions) {
        Contracts.throwIfNull(callback, "callback");
        Contracts.throwIfNull(audioProcessingOptions, "audioProcessingOptions");
        PullAudioInputStream pullStream = PullAudioInputStream.create(callback);
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioInputFromStream(configHandle, pullStream.getImpl(), audioProcessingOptions.getImpl()));
        AudioConfig config = new AudioConfig(configHandle, pullStream);
        config.closeKeepAliveOnClose = true;
        return config;
    }

    public static AudioConfig fromDefaultSpeakerOutput() {
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioOutputFromDefaultSpeaker(configHandle));
        return new AudioConfig(configHandle);
    }

    public static AudioConfig fromSpeakerOutput(String deviceName) {
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioOutputFromSpeakerOutput(configHandle, deviceName));
        return new AudioConfig(configHandle);
    }

    public static AudioConfig fromWavFileOutput(String fileName) {
        Contracts.throwIfNull(fileName, "fileName");
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioOutputFromWavFileName(configHandle, fileName));
        return new AudioConfig(configHandle);
    }

    public static AudioConfig fromStreamOutput(AudioOutputStream audioStream) {
        IntRef configHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioConfig.createAudioOutputFromStream(configHandle, audioStream.getImpl()));
        return new AudioConfig(configHandle, audioStream);
    }

    public AudioProcessingOptions getAudioProcessingOptions() {
        IntRef audioProcessingOptionsHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getAudioProcessingOptions(this.audioConfigHandle, audioProcessingOptionsHandle));
        return new AudioProcessingOptions(audioProcessingOptionsHandle);
    }

    @Override
    public void close() {
        if (this.inputStreamKeepAlive != null && this.closeKeepAliveOnClose) {
            this.inputStreamKeepAlive.close();
        }
        this.inputStreamKeepAlive = null;
        if (this.propertyHandle != null) {
            this.propertyHandle.close();
            this.propertyHandle = null;
        }
        if (this.audioConfigHandle != null) {
            this.audioConfigHandle.close();
            this.audioConfigHandle = null;
        }
    }

    public void setProperty(String name, String value) {
        Contracts.throwIfNullOrWhitespace(name, "name");
        this.propertyHandle.setProperty(name, value);
    }

    public void setProperty(PropertyId id, String value) {
        this.propertyHandle.setProperty(id, value);
    }

    AudioConfig(IntRef config) {
        Contracts.throwIfNull(config, "config");
        this.audioConfigHandle = new SafeHandle(config.getValue(), SafeHandleType.AudioConfig);
        this.inputStreamKeepAlive = null;
        this.outputStreamKeepAlive = null;
        IntRef propHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBag(this.audioConfigHandle, propHandle));
        this.propertyHandle = new PropertyCollection(propHandle);
    }

    AudioConfig(IntRef config, AudioInputStream audioStream) {
        this(config);
        this.inputStreamKeepAlive = audioStream;
    }

    AudioConfig(IntRef config, AudioOutputStream audioStream) {
        this(config);
        this.outputStreamKeepAlive = audioStream;
    }

    public SafeHandle getImpl() {
        return this.audioConfigHandle;
    }

    private static final native long createAudioInputFromWavFileName(IntRef var0, String var1, SafeHandle var2);

    private static final native long createAudioInputFromDefaultMicrophone(IntRef var0, SafeHandle var1);

    private static final native long createAudioInputFromMicrophoneInput(IntRef var0, String var1, SafeHandle var2);

    private static final native long createAudioInputFromStream(IntRef var0, SafeHandle var1, SafeHandle var2);

    private static final native long createAudioOutputFromDefaultSpeaker(IntRef var0);

    private static final native long createAudioOutputFromSpeakerOutput(IntRef var0, String var1);

    private static final native long createAudioOutputFromWavFileName(IntRef var0, String var1);

    private static final native long createAudioOutputFromStream(IntRef var0, SafeHandle var1);

    private final native long getAudioProcessingOptions(SafeHandle var1, IntRef var2);

    private final native long getPropertyBag(SafeHandle var1, IntRef var2);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

