/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioStreamFormat;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.PullAudioInputStreamCallback;
import com.microsoft.cognitiveservices.speech.audio.PushAudioInputStream;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;

public class AudioInputStream
implements AutoCloseable {
    private SafeHandle streamHandle = null;

    public static PushAudioInputStream createPushStream() {
        return PushAudioInputStream.create();
    }

    public static PushAudioInputStream createPushStream(AudioStreamFormat format) {
        return PushAudioInputStream.create(format);
    }

    public static PullAudioInputStream createPullStream(PullAudioInputStreamCallback callback) {
        return PullAudioInputStream.create(callback);
    }

    public static PullAudioInputStream createPullStream(PullAudioInputStreamCallback callback, AudioStreamFormat format) {
        return PullAudioInputStream.create(callback, format);
    }

    @Override
    public void close() {
        if (this.streamHandle != null) {
            this.streamHandle.close();
            this.streamHandle = null;
        }
    }

    AudioInputStream(SafeHandle stream) {
        Contracts.throwIfNull(stream, "stream");
        this.streamHandle = stream;
    }

    public SafeHandle getImpl() {
        return this.streamHandle;
    }

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

