/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.MicrophoneArrayGeometry;
import com.microsoft.cognitiveservices.speech.audio.MicrophoneArrayType;
import com.microsoft.cognitiveservices.speech.audio.MicrophoneCoordinates;
import com.microsoft.cognitiveservices.speech.audio.PresetMicrophoneArrayGeometry;
import com.microsoft.cognitiveservices.speech.audio.SpeakerReferenceChannel;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public class AudioProcessingOptions
implements AutoCloseable {
    private SafeHandle audioProcessingOptionsHandle = null;

    public static AudioProcessingOptions create(int audioProcessingFlags) {
        IntRef processingOptionsHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioProcessingOptions.create(processingOptionsHandle, audioProcessingFlags));
        return new AudioProcessingOptions(processingOptionsHandle);
    }

    public static AudioProcessingOptions create(int audioProcessingFlags, PresetMicrophoneArrayGeometry microphoneArrayGeometry) {
        return AudioProcessingOptions.create(audioProcessingFlags, microphoneArrayGeometry, SpeakerReferenceChannel.None);
    }

    public static AudioProcessingOptions create(int audioProcessingFlags, PresetMicrophoneArrayGeometry microphoneArrayGeometry, SpeakerReferenceChannel speakerReferenceChannel) {
        Contracts.throwIfNull((Object)microphoneArrayGeometry, "microphoneArrayGeometry");
        Contracts.throwIfNull((Object)speakerReferenceChannel, "speakerReferenceChannel");
        IntRef processingOptionsHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioProcessingOptions.createFromPresetMicrophoneArrayGeometry(processingOptionsHandle, audioProcessingFlags, microphoneArrayGeometry.ordinal(), speakerReferenceChannel.ordinal()));
        return new AudioProcessingOptions(processingOptionsHandle);
    }

    public static AudioProcessingOptions create(int audioProcessingFlags, MicrophoneArrayGeometry microphoneArrayGeometry) {
        return AudioProcessingOptions.create(audioProcessingFlags, microphoneArrayGeometry, SpeakerReferenceChannel.None);
    }

    public static AudioProcessingOptions create(int audioProcessingFlags, MicrophoneArrayGeometry microphoneArrayGeometry, SpeakerReferenceChannel speakerReferenceChannel) {
        Contracts.throwIfNull(microphoneArrayGeometry, "microphoneArrayGeometry");
        Contracts.throwIfNull((Object)speakerReferenceChannel, "speakerReferenceChannel");
        IntRef processingOptionsHandle = new IntRef(0L);
        Contracts.throwIfFail(AudioProcessingOptions.createFromMicrophoneArrayGeometry(processingOptionsHandle, audioProcessingFlags, microphoneArrayGeometry, speakerReferenceChannel.ordinal()));
        return new AudioProcessingOptions(processingOptionsHandle);
    }

    public int getAudioProcessingFlags() {
        IntRef audioProcessingFlags = new IntRef(0L);
        Contracts.throwIfFail(this.getAudioProcessingFlags(this.audioProcessingOptionsHandle, audioProcessingFlags));
        return (int)audioProcessingFlags.getValue();
    }

    public PresetMicrophoneArrayGeometry getPresetMicrophoneArrayGeometry() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getPresetMicrophoneArrayGeometry(this.audioProcessingOptionsHandle, intRef));
        return PresetMicrophoneArrayGeometry.values()[(int)intRef.getValue()];
    }

    public MicrophoneArrayType getMicrophoneArrayType() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getMicrophoneArrayType(this.audioProcessingOptionsHandle, intRef));
        return MicrophoneArrayType.values()[(int)intRef.getValue()];
    }

    public int getBeamformingStartAngle() {
        IntRef beamformingStartAngle = new IntRef(0L);
        Contracts.throwIfFail(this.getBeamformingStartAngle(this.audioProcessingOptionsHandle, beamformingStartAngle));
        return (int)beamformingStartAngle.getValue();
    }

    public int getBeamformingEndAngle() {
        IntRef beamformingEndAngle = new IntRef(0L);
        Contracts.throwIfFail(this.getBeamformingEndAngle(this.audioProcessingOptionsHandle, beamformingEndAngle));
        return (int)beamformingEndAngle.getValue();
    }

    public MicrophoneCoordinates[] getMicrophoneCoordinates() {
        IntRef hr = new IntRef(0L);
        MicrophoneCoordinates[] microphoneCoordinates = this.getMicrophoneCoordinates(this.audioProcessingOptionsHandle, hr);
        Contracts.throwIfFail(hr.getValue());
        return microphoneCoordinates;
    }

    public SpeakerReferenceChannel getSpeakerReferenceChannel() {
        IntRef intRef = new IntRef(0L);
        Contracts.throwIfFail(this.getSpeakerReferenceChannel(this.audioProcessingOptionsHandle, intRef));
        return SpeakerReferenceChannel.values()[(int)intRef.getValue()];
    }

    @Override
    public void close() {
        if (this.audioProcessingOptionsHandle != null) {
            this.audioProcessingOptionsHandle.close();
            this.audioProcessingOptionsHandle = null;
        }
    }

    AudioProcessingOptions(IntRef audioProcessingOptions) {
        Contracts.throwIfNull(audioProcessingOptions, "audioProcessingOptions");
        this.audioProcessingOptionsHandle = new SafeHandle(audioProcessingOptions.getValue(), SafeHandleType.AudioProcessingOptions);
    }

    public SafeHandle getImpl() {
        return this.audioProcessingOptionsHandle;
    }

    private static final native long create(IntRef var0, int var1);

    private static final native long createFromPresetMicrophoneArrayGeometry(IntRef var0, int var1, int var2, int var3);

    private static final native long createFromMicrophoneArrayGeometry(IntRef var0, int var1, MicrophoneArrayGeometry var2, int var3);

    private final native long getAudioProcessingFlags(SafeHandle var1, IntRef var2);

    private final native long getPresetMicrophoneArrayGeometry(SafeHandle var1, IntRef var2);

    private final native long getMicrophoneArrayType(SafeHandle var1, IntRef var2);

    private final native long getBeamformingStartAngle(SafeHandle var1, IntRef var2);

    private final native long getBeamformingEndAngle(SafeHandle var1, IntRef var2);

    private final native MicrophoneCoordinates[] getMicrophoneCoordinates(SafeHandle var1, IntRef var2);

    private final native long getSpeakerReferenceChannel(SafeHandle var1, IntRef var2);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

