/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioStreamContainerFormat;
import com.microsoft.cognitiveservices.speech.audio.AudioStreamWaveFormat;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class AudioStreamFormat {
    private SafeHandle formatHandle = null;

    public static AudioStreamFormat getDefaultInputFormat() {
        SafeHandle streamFormatHandle = new SafeHandle(0L, SafeHandleType.AudioStreamFormat);
        Contracts.throwIfFail(AudioStreamFormat.createFromDefaultInput(streamFormatHandle));
        return new AudioStreamFormat(streamFormatHandle);
    }

    public static AudioStreamFormat getWaveFormat(long samplesPerSecond, short bitsPerSample, short channels, AudioStreamWaveFormat waveFormat) {
        SafeHandle streamFormatHandle = new SafeHandle(0L, SafeHandleType.AudioStreamFormat);
        int format = AudioStreamWaveFormat.values()[waveFormat.ordinal()].getValue();
        Contracts.throwIfFail(AudioStreamFormat.createFromWaveFormat(streamFormatHandle, samplesPerSecond, bitsPerSample, channels, format));
        return new AudioStreamFormat(streamFormatHandle);
    }

    public static AudioStreamFormat getWaveFormatPCM(long samplesPerSecond, short bitsPerSample, short channels) {
        SafeHandle streamFormatHandle = new SafeHandle(0L, SafeHandleType.AudioStreamFormat);
        Contracts.throwIfFail(AudioStreamFormat.createFromWaveFormat(streamFormatHandle, samplesPerSecond, bitsPerSample, channels, AudioStreamWaveFormat.PCM.getValue()));
        return new AudioStreamFormat(streamFormatHandle);
    }

    public static AudioStreamFormat getCompressedFormat(AudioStreamContainerFormat compressedFormat) {
        SafeHandle streamFormatHandle = new SafeHandle(0L, SafeHandleType.AudioStreamFormat);
        int value = AudioStreamContainerFormat.values()[compressedFormat.ordinal()].getValue();
        Contracts.throwIfFail(AudioStreamFormat.createFromCompressedFormat(streamFormatHandle, value));
        return new AudioStreamFormat(streamFormatHandle);
    }

    public void close() {
        if (this.formatHandle != null) {
            this.formatHandle.close();
            this.formatHandle = null;
        }
    }

    AudioStreamFormat(SafeHandle format) {
        Contracts.throwIfNull(format, "format");
        this.formatHandle = format;
    }

    public SafeHandle getImpl() {
        return this.formatHandle;
    }

    private static final native long createFromDefaultInput(SafeHandle var0);

    private static final native long createFromWaveFormat(SafeHandle var0, long var1, short var3, short var4, int var5);

    private static final native long createFromCompressedFormat(SafeHandle var0, int var1);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

