/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.audio.MicrophoneArrayType;
import com.microsoft.cognitiveservices.speech.audio.MicrophoneCoordinates;
import com.microsoft.cognitiveservices.speech.util.Contracts;

public class MicrophoneArrayGeometry {
    private MicrophoneArrayType microphoneArrayType;
    private int beamformingStartAngle;
    private int beamformingEndAngle;
    private MicrophoneCoordinates[] microphoneCoordinates;

    public MicrophoneArrayGeometry(MicrophoneArrayType microphoneArrayType, MicrophoneCoordinates[] microphoneCoordinates) {
        Contracts.throwIfNull(microphoneCoordinates, "microphoneCoordinates");
        this.microphoneArrayType = microphoneArrayType;
        this.beamformingStartAngle = 0;
        this.beamformingEndAngle = microphoneArrayType == MicrophoneArrayType.Linear ? 180 : 360;
        this.microphoneCoordinates = new MicrophoneCoordinates[microphoneCoordinates.length];
        for (int i = 0; i < microphoneCoordinates.length; ++i) {
            this.microphoneCoordinates[i] = new MicrophoneCoordinates(microphoneCoordinates[i]);
        }
    }

    public MicrophoneArrayGeometry(MicrophoneArrayType microphoneArrayType, int beamformingStartAngle, int beamformingEndAngle, MicrophoneCoordinates[] microphoneCoordinates) {
        Contracts.throwIfNull(microphoneCoordinates, "microphoneCoordinates");
        if (beamformingStartAngle < 0) {
            throw new IllegalArgumentException("beamformingStartAngle cannot be negative");
        }
        if (beamformingEndAngle < 0) {
            throw new IllegalArgumentException("beamformingEndAngle cannot be negative");
        }
        this.microphoneArrayType = microphoneArrayType;
        this.beamformingStartAngle = beamformingStartAngle;
        this.beamformingEndAngle = beamformingEndAngle;
        this.microphoneCoordinates = new MicrophoneCoordinates[microphoneCoordinates.length];
        for (int i = 0; i < microphoneCoordinates.length; ++i) {
            this.microphoneCoordinates[i] = new MicrophoneCoordinates(microphoneCoordinates[i]);
        }
    }

    public MicrophoneArrayType getMicrophoneArrayType() {
        return this.microphoneArrayType;
    }

    public int getBeamformingStartAngle() {
        return this.beamformingStartAngle;
    }

    public int getBeamformingEndAngle() {
        return this.beamformingEndAngle;
    }

    public MicrophoneCoordinates[] getMicrophoneCoordinates() {
        MicrophoneCoordinates[] microphoneCoordinates = new MicrophoneCoordinates[this.microphoneCoordinates.length];
        for (int i = 0; i < microphoneCoordinates.length; ++i) {
            microphoneCoordinates[i] = new MicrophoneCoordinates(this.microphoneCoordinates[i]);
        }
        return microphoneCoordinates;
    }
}

