/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.audio;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.audio.AudioInputStream;
import com.microsoft.cognitiveservices.speech.audio.AudioStreamFormat;
import com.microsoft.cognitiveservices.speech.util.CloseGuard;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class PushAudioInputStream
extends AudioInputStream {
    private CloseGuard cg = new CloseGuard();

    public static PushAudioInputStream create() {
        SafeHandle audioStreamHandle = new SafeHandle(0L, SafeHandleType.AudioInputStream);
        Contracts.throwIfFail(PushAudioInputStream.createPushAudioInputStream(audioStreamHandle, null));
        return new PushAudioInputStream(audioStreamHandle);
    }

    public static PushAudioInputStream create(AudioStreamFormat format) {
        SafeHandle audioStreamHandle = new SafeHandle(0L, SafeHandleType.AudioInputStream);
        Contracts.throwIfFail(PushAudioInputStream.createPushAudioInputStream(audioStreamHandle, format.getImpl()));
        return new PushAudioInputStream(audioStreamHandle);
    }

    public void write(byte[] dataBuffer) {
        this.cg.enterUseObject();
        try {
            Contracts.throwIfFail(this.pushAudioInputStreamWrite(this.getImpl(), dataBuffer, dataBuffer.length));
        }
        finally {
            this.cg.exitUseObject();
        }
    }

    @Override
    public void close() {
        this.cg.closeObject();
        if (this.getImpl() != null) {
            Contracts.throwIfFail(this.pushAudioInputStreamClose(this.getImpl()));
        }
        super.close();
    }

    PushAudioInputStream(SafeHandle stream) {
        super(stream);
    }

    private static final native long createPushAudioInputStream(SafeHandle var0, SafeHandle var1);

    private final native long pushAudioInputStreamWrite(SafeHandle var1, byte[] var2, int var3);

    private final native long pushAudioInputStreamClose(SafeHandle var1);

    static {
        try {
            Class.forName(SpeechConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
    }
}

