/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.dialog;

import com.microsoft.cognitiveservices.speech.audio.PullAudioOutputStream;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;

public class ActivityReceivedEventArgs {
    private SafeHandle activityReceivedEventHandle = null;
    private String activity = "";
    private boolean hasAudio = false;

    public ActivityReceivedEventArgs(long eventArgs) {
        Contracts.throwIfNull(eventArgs, "eventArgs");
        this.activityReceivedEventHandle = new SafeHandle(eventArgs, SafeHandleType.ActivityReceivedEvent);
        StringRef activityRef = new StringRef("");
        Contracts.throwIfFail(this.getActivity(this.activityReceivedEventHandle, activityRef));
        this.activity = activityRef.getValue();
        this.hasAudio = this.hasAudio(this.activityReceivedEventHandle);
    }

    public String getActivity() {
        return this.activity;
    }

    public boolean hasAudio() {
        return this.hasAudio;
    }

    public PullAudioOutputStream getAudio() {
        IntRef audioRef = new IntRef(0L);
        Contracts.throwIfFail(this.getAudio(this.activityReceivedEventHandle, audioRef));
        return new PullAudioOutputStream(audioRef);
    }

    private final native long getAudio(SafeHandle var1, IntRef var2);

    private final native long getActivity(SafeHandle var1, StringRef var2);

    private final native boolean hasAudio(SafeHandle var1);
}

