/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.dialog;

import com.microsoft.cognitiveservices.speech.KeywordRecognitionModel;
import com.microsoft.cognitiveservices.speech.PropertyCollection;
import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.RecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.SessionEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionCanceledEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionEventArgs;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionResult;
import com.microsoft.cognitiveservices.speech.audio.AudioConfig;
import com.microsoft.cognitiveservices.speech.dialog.ActivityReceivedEventArgs;
import com.microsoft.cognitiveservices.speech.dialog.DialogServiceConfig;
import com.microsoft.cognitiveservices.speech.dialog.TurnStatusReceivedEventArgs;
import com.microsoft.cognitiveservices.speech.util.AsyncThreadService;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.EventHandlerImpl;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;

public class DialogServiceConnector
implements AutoCloseable {
    static Class<?> dialogServiceConnector = null;
    private AtomicInteger eventCounter = new AtomicInteger(0);
    private AudioConfig audioInputKeepAlive = null;
    private PropertyCollection propertyHandle;
    public EventHandlerImpl<SpeechRecognitionEventArgs> recognizing = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<SpeechRecognitionEventArgs> recognized = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<SessionEventArgs> sessionStarted = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<SessionEventArgs> sessionStopped = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<RecognitionEventArgs> speechStartDetected = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<RecognitionEventArgs> speechEndDetected = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<SpeechRecognitionCanceledEventArgs> canceled = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<ActivityReceivedEventArgs> activityReceived = new EventHandlerImpl(this.eventCounter);
    public EventHandlerImpl<TurnStatusReceivedEventArgs> turnStatusReceived = new EventHandlerImpl(this.eventCounter);
    static Set<DialogServiceConnector> dialogServiceConnectorObjects;
    private SafeHandle dialogServiceConnectorHandle = null;
    private boolean disposed = false;

    public DialogServiceConnector(DialogServiceConfig config) {
        this(config, AudioConfig.fromDefaultMicrophoneInput());
    }

    public DialogServiceConnector(DialogServiceConfig config, AudioConfig audioConfig) {
        Contracts.throwIfNull(config, "config");
        if (audioConfig == null) {
            this.dialogServiceConnectorHandle = new SafeHandle(0L, SafeHandleType.DialogServiceConnector);
            Contracts.throwIfFail(DialogServiceConnector.createDialogServiceConnectorFomConfig(this.dialogServiceConnectorHandle, config.getImpl(), null));
        } else {
            this.dialogServiceConnectorHandle = new SafeHandle(0L, SafeHandleType.DialogServiceConnector);
            Contracts.throwIfFail(DialogServiceConnector.createDialogServiceConnectorFomConfig(this.dialogServiceConnectorHandle, config.getImpl(), audioConfig.getImpl()));
        }
        this.audioInputKeepAlive = audioConfig;
        this.initialize();
    }

    public void setAuthorizationToken(String token) {
        Contracts.throwIfNullOrWhitespace(token, "token");
        this.propertyHandle.setProperty(PropertyId.SpeechServiceAuthorization_Token, token);
    }

    public String getAuthorizationToken() {
        return this.propertyHandle.getProperty(PropertyId.SpeechServiceAuthorization_Token);
    }

    public PropertyCollection getProperties() {
        return this.propertyHandle;
    }

    public Future<Void> connectAsync() {
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Contracts.throwIfFail(DialogServiceConnector.this.connect(DialogServiceConnector.this.dialogServiceConnectorHandle));
                return null;
            }
        });
    }

    public Future<Void> disconnectAsync() {
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Contracts.throwIfFail(DialogServiceConnector.this.disconnect(DialogServiceConnector.this.dialogServiceConnectorHandle));
                return null;
            }
        });
    }

    public Future<String> sendActivityAsync(final String activity) {
        Contracts.throwIfNull(activity, "activity");
        return AsyncThreadService.submit(new Callable<String>(){

            @Override
            public String call() {
                StringRef stringRef = new StringRef("");
                Contracts.throwIfFail(DialogServiceConnector.this.sendActivity(DialogServiceConnector.this.dialogServiceConnectorHandle, stringRef, activity));
                return stringRef.getValue();
            }
        });
    }

    public void setSpeechActivityTemplate(String activityTemplate) {
        Contracts.throwIfNullOrWhitespace(activityTemplate, "template");
        this.propertyHandle.setProperty(PropertyId.Conversation_Speech_Activity_Template, activityTemplate);
    }

    public Future<SpeechRecognitionResult> listenOnceAsync() {
        return AsyncThreadService.submit(new Callable<SpeechRecognitionResult>(){

            @Override
            public SpeechRecognitionResult call() {
                IntRef result = new IntRef(0L);
                Contracts.throwIfFail(DialogServiceConnector.this.listenOnce(DialogServiceConnector.this.dialogServiceConnectorHandle, result));
                return new DialogSpeechRecognitionResult(result.getValue());
            }
        });
    }

    public Future<Void> stopListeningAsync() {
        final DialogServiceConnector thisConnector = this;
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Contracts.throwIfFail(thisConnector.stopListening(thisConnector.dialogServiceConnectorHandle));
                return null;
            }
        });
    }

    public Future<Void> startKeywordRecognitionAsync(final KeywordRecognitionModel model) {
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Contracts.throwIfFail(DialogServiceConnector.this.startKeywordRecognition(DialogServiceConnector.this.dialogServiceConnectorHandle, model.getImpl()));
                return null;
            }
        });
    }

    public Future<Void> stopKeywordRecognitionAsync() {
        return AsyncThreadService.submit(new Callable<Void>(){

            @Override
            public Void call() {
                Contracts.throwIfFail(DialogServiceConnector.this.stopKeywordRecognition(DialogServiceConnector.this.dialogServiceConnectorHandle));
                return null;
            }
        });
    }

    private void initialize() {
        final DialogServiceConnector _this = this;
        AsyncThreadService.initialize();
        this.recognizing.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(_this);
                Contracts.throwIfFail(DialogServiceConnector.this.recognizingSetCallback(_this.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.recognized.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(_this);
                Contracts.throwIfFail(DialogServiceConnector.this.recognizedSetCallback(_this.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.sessionStarted.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(_this);
                Contracts.throwIfFail(DialogServiceConnector.this.sessionStartedSetCallback(_this.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.sessionStopped.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(_this);
                Contracts.throwIfFail(DialogServiceConnector.this.sessionStoppedSetCallback(_this.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.speechStartDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(_this);
                Contracts.throwIfFail(DialogServiceConnector.this.speechStartDetectedSetCallback(_this.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.speechEndDetected.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(_this);
                Contracts.throwIfFail(DialogServiceConnector.this.speechEndDetectedSetCallback(_this.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.canceled.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(_this);
                Contracts.throwIfFail(DialogServiceConnector.this.canceledSetCallback(_this.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.activityReceived.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(_this);
                Contracts.throwIfFail(DialogServiceConnector.this.activityReceivedSetCallback(_this.dialogServiceConnectorHandle.getValue()));
            }
        });
        this.turnStatusReceived.updateNotificationOnConnected(new Runnable(){

            @Override
            public void run() {
                dialogServiceConnectorObjects.add(_this);
                Contracts.throwIfFail(DialogServiceConnector.this.turnStatusReceivedSetCallback(_this.dialogServiceConnectorHandle.getValue()));
            }
        });
        IntRef propHandle = new IntRef(0L);
        Contracts.throwIfFail(this.getPropertyBagFromDialogServiceConnectorHandle(_this.dialogServiceConnectorHandle, propHandle));
        this.propertyHandle = new PropertyCollection(propHandle);
    }

    private void recognizingEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            SpeechRecognitionEventArgs resultEventArg = new SpeechRecognitionEventArgs(eventArgs, true);
            EventHandlerImpl<SpeechRecognitionEventArgs> handler = this.recognizing;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void recognizedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            SpeechRecognitionEventArgs resultEventArg = new SpeechRecognitionEventArgs(eventArgs, true);
            EventHandlerImpl<SpeechRecognitionEventArgs> handler = this.recognized;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sessionStartedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            SessionEventArgs arg = new SessionEventArgs(eventArgs, true);
            EventHandlerImpl<SessionEventArgs> handler = this.sessionStarted;
            if (handler != null) {
                handler.fireEvent(this, arg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sessionStoppedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            SessionEventArgs arg = new SessionEventArgs(eventArgs, true);
            EventHandlerImpl<SessionEventArgs> handler = this.sessionStopped;
            if (handler != null) {
                handler.fireEvent(this, arg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void speechStartDetectedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            RecognitionEventArgs args = new RecognitionEventArgs(eventArgs, true);
            EventHandlerImpl<RecognitionEventArgs> handler = this.speechStartDetected;
            if (handler != null) {
                handler.fireEvent(this, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void speechEndDetectedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            RecognitionEventArgs args = new RecognitionEventArgs(eventArgs, true);
            EventHandlerImpl<RecognitionEventArgs> handler = this.speechEndDetected;
            if (handler != null) {
                handler.fireEvent(this, args);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void canceledEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            SpeechRecognitionCanceledEventArgs resultEventArg = new SpeechRecognitionCanceledEventArgs(eventArgs, true);
            EventHandlerImpl<SpeechRecognitionCanceledEventArgs> handler = this.canceled;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void activityReceivedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            ActivityReceivedEventArgs resultEventArg = new ActivityReceivedEventArgs(eventArgs);
            EventHandlerImpl<ActivityReceivedEventArgs> handler = this.activityReceived;
            if (handler != null) {
                handler.fireEvent(this, resultEventArg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void turnStatusReceivedEventCallback(long eventArgs) {
        try {
            Contracts.throwIfNull(this, "connector");
            if (this.disposed) {
                return;
            }
            TurnStatusReceivedEventArgs statusArgs = new TurnStatusReceivedEventArgs(eventArgs);
            EventHandlerImpl<TurnStatusReceivedEventArgs> handler = this.turnStatusReceived;
            if (handler != null) {
                handler.fireEvent(this, statusArgs);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public SafeHandle getImpl() {
        return this.dialogServiceConnectorHandle;
    }

    @Override
    public void close() {
        this.dispose(true);
    }

    private void dispose(boolean disposing) {
        if (this.disposed) {
            return;
        }
        if (disposing) {
            if (this.propertyHandle != null) {
                this.propertyHandle.close();
                this.propertyHandle = null;
            }
            if (this.dialogServiceConnectorHandle != null) {
                this.dialogServiceConnectorHandle.close();
                this.dialogServiceConnectorHandle = null;
            }
            this.audioInputKeepAlive = null;
            dialogServiceConnectorObjects.remove(this);
            AsyncThreadService.shutdown();
            this.disposed = true;
        }
    }

    private static final native long createDialogServiceConnectorFomConfig(SafeHandle var0, SafeHandle var1, SafeHandle var2);

    private final native long connect(SafeHandle var1);

    private final native long disconnect(SafeHandle var1);

    private final native long sendActivity(SafeHandle var1, StringRef var2, String var3);

    private final native long listenOnce(SafeHandle var1, IntRef var2);

    private final native long stopListening(SafeHandle var1);

    private final native long startKeywordRecognition(SafeHandle var1, SafeHandle var2);

    private final native long stopKeywordRecognition(SafeHandle var1);

    private final native long recognizingSetCallback(long var1);

    private final native long recognizedSetCallback(long var1);

    private final native long sessionStartedSetCallback(long var1);

    private final native long sessionStoppedSetCallback(long var1);

    private final native long speechStartDetectedSetCallback(long var1);

    private final native long speechEndDetectedSetCallback(long var1);

    private final native long canceledSetCallback(long var1);

    private final native long activityReceivedSetCallback(long var1);

    private final native long turnStatusReceivedSetCallback(long var1);

    private final native long getPropertyBagFromDialogServiceConnectorHandle(SafeHandle var1, IntRef var2);

    static {
        try {
            Class.forName(DialogServiceConfig.class.getName());
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalStateException(ex);
        }
        dialogServiceConnector = DialogServiceConnector.class;
        dialogServiceConnectorObjects = Collections.synchronizedSet(new HashSet());
    }

    private class DialogSpeechRecognitionResult
    extends SpeechRecognitionResult {
        DialogSpeechRecognitionResult(long resultHandle) {
            super(resultHandle);
        }
    }
}

