/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.PropertyId;
import com.microsoft.cognitiveservices.speech.ResultReason;
import com.microsoft.cognitiveservices.speech.SpeechRecognitionResult;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.JsonValue;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.StringRef;
import java.util.Dictionary;
import java.util.Hashtable;

public final class IntentRecognitionResult
extends SpeechRecognitionResult {
    private Dictionary<String, String> entities;
    private String intentId;

    IntentRecognitionResult(long result) {
        super(result);
        Contracts.throwIfNull(super.getImpl(), "resultHandle");
        StringRef intentIdStr = new StringRef("");
        Contracts.throwIfFail(this.getIntentId(super.getImpl(), intentIdStr));
        this.intentId = intentIdStr.getValue();
        Contracts.throwIfNull(this.intentId, "IntentId");
        if (this.getReason() == ResultReason.RecognizedIntent) {
            String jsonSLE = this.getProperties().getProperty("LanguageUnderstandingSLE_JsonResult");
            this.entities = new Hashtable<String, String>();
            if (jsonSLE != null) {
                JsonValue parsed = JsonValue.Parse(jsonSLE);
                int count = parsed.count();
                for (int i = 0; i < count; ++i) {
                    String name = parsed.getName(i);
                    String value = parsed.get(i).asString();
                    this.entities.put(name, value);
                }
            }
        }
    }

    @Override
    public void close() {
        super.close();
    }

    public Dictionary<String, String> getEntities() {
        return this.entities;
    }

    public String getIntentId() {
        return this.intentId;
    }

    @Override
    public String toString() {
        return "ResultId:" + this.getResultId() + " Reason:" + (Object)((Object)this.getReason()) + " IntentId:<" + this.intentId + "> Recognized text:<" + this.getText() + "> Recognized json:<" + this.getProperties().getProperty(PropertyId.SpeechServiceResponse_JsonResult) + "> LanguageUnderstandingJson <" + this.getProperties().getProperty(PropertyId.LanguageUnderstandingServiceResponse_JsonResult) + ">.";
    }

    private final native long getIntentId(SafeHandle var1, StringRef var2);
}

