/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;

public final class IntentTrigger
implements AutoCloseable {
    private SafeHandle triggerHandle = null;

    public static IntentTrigger fromPhrase(String simplePhrase) {
        IntRef trigger = new IntRef(0L);
        Contracts.throwIfFail(IntentTrigger.createFromPhrase(trigger, simplePhrase));
        return new IntentTrigger(trigger);
    }

    public static IntentTrigger fromModel(SafeHandle modelHandle) {
        IntRef trigger = new IntRef(0L);
        Contracts.throwIfFail(IntentTrigger.createFromLanguageUnderstandingModel(trigger, modelHandle, null));
        return new IntentTrigger(trigger);
    }

    public static IntentTrigger fromModel(SafeHandle modelHandle, String intentName) {
        IntRef trigger = new IntRef(0L);
        Contracts.throwIfFail(IntentTrigger.createFromLanguageUnderstandingModel(trigger, modelHandle, intentName));
        return new IntentTrigger(trigger);
    }

    @Override
    public void close() {
        if (this.triggerHandle != null) {
            this.triggerHandle.close();
            this.triggerHandle = null;
        }
    }

    public SafeHandle getImpl() {
        return this.triggerHandle;
    }

    private IntentTrigger(IntRef trigger) {
        this.triggerHandle = new SafeHandle(trigger.getValue(), SafeHandleType.IntentTrigger);
    }

    private static final native long createFromPhrase(IntRef var0, String var1);

    private static final native long createFromLanguageUnderstandingModel(IntRef var0, SafeHandle var1, String var2);
}

