/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.intent;

import com.microsoft.cognitiveservices.speech.util.KeyedItem;
import java.util.ArrayList;
import java.util.Collection;

public class PatternMatchingEntity
implements KeyedItem {
    private String entityId;
    private EntityMatchMode mode;
    private EntityType type;
    public Collection<String> Phrases;

    @Override
    public String getId() {
        return this.entityId;
    }

    public void setId(String id) {
        this.entityId = id;
    }

    public EntityMatchMode getMatchMode() {
        return this.mode;
    }

    public void setMatchMode(EntityMatchMode mode) {
        this.mode = mode;
    }

    public EntityType getType() {
        return this.type;
    }

    public void setType(EntityType type) {
        this.type = type;
    }

    PatternMatchingEntity(String entityId, EntityType type, EntityMatchMode mode, Collection<String> phrases) {
        this.entityId = entityId;
        this.type = type;
        this.mode = mode;
        this.Phrases = phrases == null ? new ArrayList<String>() : phrases;
    }

    public static PatternMatchingEntity CreateAnyEntity(String entityId) {
        return new PatternMatchingEntity(entityId, EntityType.Any, EntityMatchMode.Basic, null);
    }

    public static PatternMatchingEntity CreateIntegerEntity(String entityId) {
        return new PatternMatchingEntity(entityId, EntityType.PrebuiltInteger, EntityMatchMode.Basic, null);
    }

    public static PatternMatchingEntity CreateListEntity(String entityId, EntityMatchMode mode, Collection<String> phrases) {
        return new PatternMatchingEntity(entityId, EntityType.List, mode, phrases);
    }

    public static PatternMatchingEntity CreateListEntity(String entityId, EntityMatchMode mode, String ... phrases) {
        ArrayList<String> list = new ArrayList<String>();
        for (String phrase : phrases) {
            list.add(phrase);
        }
        return new PatternMatchingEntity(entityId, EntityType.List, mode, list);
    }

    public static enum EntityType {
        Any(0),
        List(1),
        PrebuiltInteger(2);

        private final int id;

        private EntityType(int id) {
            this.id = id;
        }

        public int getValue() {
            return this.id;
        }
    }

    public static enum EntityMatchMode {
        Basic(0),
        Strict(1),
        Fuzzy(2);

        private final int id;

        private EntityMatchMode(int id) {
            this.id = id;
        }

        public int getValue() {
            return this.id;
        }
    }
}

