/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.cognitiveservices.speech.speaker;

import com.microsoft.cognitiveservices.speech.SpeechConfig;
import com.microsoft.cognitiveservices.speech.speaker.VoiceProfile;
import com.microsoft.cognitiveservices.speech.util.Contracts;
import com.microsoft.cognitiveservices.speech.util.IntRef;
import com.microsoft.cognitiveservices.speech.util.SafeHandle;
import com.microsoft.cognitiveservices.speech.util.SafeHandleType;
import java.util.List;

public class SpeakerIdentificationModel
implements AutoCloseable {
    private boolean disposed = false;
    private SafeHandle speakerIdentificationModelHandle = null;

    public static SpeakerIdentificationModel fromProfiles(List<VoiceProfile> profiles) {
        IntRef modelHandle = new IntRef(0L);
        Contracts.throwIfNull(profiles, "profiles cannot be null");
        Contracts.throwIfFail(SpeakerIdentificationModel.createSpeakerIdentificationModel(modelHandle));
        for (VoiceProfile profile : profiles) {
            Contracts.throwIfFail(SpeakerIdentificationModel.speakerIdentificationModelAddProfile(modelHandle, profile.getImpl()));
        }
        return new SpeakerIdentificationModel(modelHandle);
    }

    @Override
    public void close() {
        if (this.disposed) {
            return;
        }
        if (this.speakerIdentificationModelHandle != null) {
            this.speakerIdentificationModelHandle.close();
            this.speakerIdentificationModelHandle = null;
        }
        this.disposed = true;
    }

    SpeakerIdentificationModel(IntRef modelHandle) {
        Contracts.throwIfNull(modelHandle, "modelHandle");
        this.speakerIdentificationModelHandle = new SafeHandle(modelHandle.getValue(), SafeHandleType.SpeakerIdentificationModel);
    }

    public SafeHandle getImpl() {
        return this.speakerIdentificationModelHandle;
    }

    private static final native long createSpeakerIdentificationModel(IntRef var0);

    private static final native long speakerIdentificationModelAddProfile(IntRef var0, SafeHandle var1);

    static {
        Class<?> clazz = SpeechConfig.speechConfigClass;
    }
}

